package com.bxm.adsmanager.web.controller.audit;

import com.bxm.adsmanager.model.vo.audit.QualificationConfigVo;
import com.bxm.adsmanager.model.vo.audit.RefuseConfigVo;
import com.bxm.adsmanager.service.audit.QualificationService;
import com.bxm.adsmanager.service.audit.RefuseService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @author 拉拉
 * @version v1.1.4_Ticket
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2019-01-04 11:48:00
 * @modifier 拉拉
 * @updated 2019-01-04 11:48:00
 */
@RestController
@RequestMapping("/audit")
public class QualificationController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(QualificationController.class);

    @Autowired
    QualificationService qualificationService;


    @RequestMapping(value = "/qualification/add", produces = "application/json")
    public ResultModel add(HttpServletRequest request, HttpServletResponse response,
                           @RequestParam(value = "name") String name,
                           @RequestParam(value = "grade") Short grade,
                           @RequestParam(value = "parentId") Long parentId,
                           @RequestParam(value = "remark",required = false) String remark,
                           @RequestParam(value = "code",required = true) Integer code) {
        try {
            // 获取后台用户名
            String userName = getUser(request, response).getUsername();
            return  qualificationService.add(name, grade, parentId, remark, userName,code);
        } catch (Exception e) {
            LOGGER.error("新增资质菜单出错", e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }

    @RequestMapping(value = "/qualification/update", produces = "application/json")
    public ResultModel update(HttpServletRequest request, HttpServletResponse response,
                              @RequestParam(value = "name") String name,
                              @RequestParam(value = "id") Long id,
                              @RequestParam(value = "remark", required = false) String remark,
                              @RequestParam(value = "code",required = true) Integer code) {
        try {
            // 获取后台用户名
            String userName = getUser(request, response).getUsername();
            return qualificationService.update(name, id, remark, userName,code);
        } catch (Exception e) {
            LOGGER.error("修改资质菜单出错", e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }

    @RequestMapping(value = "/qualification/delete", produces = "application/json")
    public ResultModel delete(HttpServletRequest request, HttpServletResponse response,
                              @RequestParam(value = "id") Long id) {
        try {
            // 获取后台用户名
            String userName = getUser(request, response).getUsername();
            qualificationService.delete(id, userName);
            return ResultModelFactory.SUCCESS();
        } catch (Exception e) {
            LOGGER.error("删除资质菜单出错", e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }

    @RequestMapping(value = "/qualification/getPageList", produces = "application/json")
    public ResultModel<PageInfo<QualificationConfigVo>> getPageList(
            @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
            @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize,
            @RequestParam(value = "keywords", required = false) String keywords,
            @RequestParam(value = "status", required = false) String status,
            @RequestParam(value = "grade", required = false) String grade,
            @RequestParam(value = "parentId",required = false) String parentId) {
        ResultModel<PageInfo<QualificationConfigVo>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(qualificationService.getPageList(grade, keywords,
                    status, pageNum, pageSize,parentId));
            resultModel.setSuccessed(true);

        } catch (Exception e) {
            LOGGER.error("查找资质菜单列表出错", e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查找资质菜单列表出错");
        }
        return resultModel;
    }

    @RequestMapping(value = "/qualification/getList", produces = "application/json")
    public ResultModel<List<QualificationConfigVo>> getList(
            @RequestParam(value = "keywords", required = false) String keywords,
            @RequestParam(value = "status", required = false) String status,
            @RequestParam(value = "grade", required = false) String grade,
            @RequestParam(value = "parentId",required = false) String parentId) {
        ResultModel<List<QualificationConfigVo>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(qualificationService.getList(grade,keywords,
                    status,parentId));
            resultModel.setSuccessed(true);

        } catch (Exception e) {
            LOGGER.error("查找资质菜单列表出错", e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查找资质菜单列表出错");
        }
        return resultModel;
    }
}
