package com.bxm.adsmanager.web.controller.audit;

import com.bxm.adsmanager.model.vo.audit.RefuseConfigVo;
import com.bxm.adsmanager.service.audit.RefuseService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @author 拉拉
 * @version v1.1.4_Ticket
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2019-01-04 11:48:00
 * @modifier 拉拉
 * @updated 2019-01-04 11:48:00
 */
@RestController
@RequestMapping("/audit")
public class RefuseController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(RefuseController.class);

    @Autowired
    RefuseService refuseService;

    /**
     * 新增拒绝原因
     *
     * @param request
     * @param response
     * @param reason
     * @param type     1 广告主  2 产品资质 3 广告
     * @return
     */
    @RequestMapping(value = "/refuse/add", produces = "application/json")
    public ResultModel add(HttpServletRequest request, HttpServletResponse response,
                           @RequestParam(value = "reason") String reason,
                           @RequestParam(value = "type") Short type) {
        try {
            // 获取后台用户名
            String userName = getUser(request, response).getUsername();
            refuseService.add(reason, type, userName);
            return ResultModelFactory.SUCCESS();
        } catch (Exception e) {
            LOGGER.error("新增拒绝原因出错", e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }

    /**
     * 修改
     *
     * @param request
     * @param response
     * @param reason   拒绝原因
     * @param id       拒绝Id
     * @return
     */
    @RequestMapping(value = "/refuse/update", produces = "application/json")
    public ResultModel update(HttpServletRequest request, HttpServletResponse response,
                              @RequestParam(value = "reason") String reason,
                              @RequestParam(value = "id") Long id) {
        try {
            // 获取后台用户名
            String userName = getUser(request, response).getUsername();
            refuseService.update(reason, id, userName);
            return ResultModelFactory.SUCCESS();
        } catch (Exception e) {
            LOGGER.error("修改拒绝原因出错", e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }

    @RequestMapping(value = "/refuse/updateStatus", produces = "application/json")
    public ResultModel delete(HttpServletRequest request, HttpServletResponse response,
                              @RequestParam(value = "id") Long id,
                              @RequestParam(value = "status") Short status) {
        try {
            // 获取后台用户名
            String userName = getUser(request, response).getUsername();
            refuseService.updateStatus(id, status,userName);
            return ResultModelFactory.SUCCESS();
        } catch (Exception e) {
            LOGGER.error("删除拒绝原因出错", e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }

    @RequestMapping(value = "/refuse/getList", produces = "application/json")
    public ResultModel<PageInfo<RefuseConfigVo>> getList(
            @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
            @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize,
            @RequestParam(value = "type", required = false) String type,
            @RequestParam(value = "status", required = false) String status) {
        ResultModel<PageInfo<RefuseConfigVo>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(refuseService.getList(type, status,pageNum,pageSize));
            resultModel.setSuccessed(true);

        } catch (Exception e) {
            LOGGER.error("查找拒绝原因列表出错", e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查找拒绝原因列表出错");
        }
        return resultModel;
    }
}
