package com.bxm.adsmanager.web.controller.audit;

import com.bxm.adsmanager.facade.model.video.VideoAssetDto;
import com.bxm.adsmanager.facade.model.video.VideoAssetVo;
import com.bxm.adsmanager.service.audit.VideoAssetService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;

/**
 * @author 拉拉
 * @version v1.1.4_Ticket
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2019-01-04 11:48:00
 * @modifier 拉拉
 * @updated 2019-01-04 11:48:00
 */
@RestController
@RequestMapping("/video")
public class VideoAssetController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(VideoAssetController.class);

    @Autowired
    VideoAssetService videoAssetService;

    @RequestMapping(value = "/asset/saveOrUpdate", produces = "application/json")
    public ResultModel add(HttpServletRequest request, HttpServletResponse response,
                           VideoAssetDto videoAssetDto) {
        try {
            // 获取后台用户名
            String userName = getUser(request, response).getUsername();
            videoAssetDto.setCreateUser(userName);
            videoAssetService.add(videoAssetDto);
            return ResultModelFactory.SUCCESS();
        } catch (Exception e) {
            LOGGER.error("新增或者修改出错", e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }

    @RequestMapping(value = "/asset/updateStatus", produces = "application/json")
    public ResultModel updateStatus(HttpServletRequest request, HttpServletResponse response,
                                    @RequestParam(value = "status") Short status,
                                    @RequestParam(value = "id") Long id
    ) {
        try {
            // 获取后台用户名
            String userName = getUser(request, response).getUsername();
            videoAssetService.updateStatus(id, status, userName);
            return ResultModelFactory.SUCCESS();
        } catch (Exception e) {
            LOGGER.error("修改状态出错", e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }

    @RequestMapping(value = "/asset/getVideoAssetVo", produces = "application/json")
    public ResultModel<VideoAssetVo> getVideoAssetVo(HttpServletRequest request, HttpServletResponse response,
                                                     @RequestParam(value = "id") Long id
    ) {
        ResultModel<VideoAssetVo> resultModel = new ResultModel<>();
        try {
            // 获取后台用户名
            resultModel.setReturnValue(videoAssetService.getVideoAssetVo(id, null));
            return ResultModelFactory.SUCCESS();
        } catch (Exception e) {
            LOGGER.error("修改状态出错", e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }

    @RequestMapping(value = "/asset/getList", produces = "application/json")
    public ResultModel<PageInfo<VideoAssetVo>> getList(
            @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
            @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize,
            @RequestParam(value = "keywords", required = false) String keywords) {
        ResultModel<PageInfo<VideoAssetVo>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(videoAssetService.getList(keywords, pageNum, pageSize));
            resultModel.setSuccessed(true);

        } catch (Exception e) {
            LOGGER.error("查找列表出错", e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查找列表出错");
        }
        return resultModel;
    }

    @RequestMapping(value = "/asset/download", produces = "application/json")
    public void download(HttpServletRequest request,
                         HttpServletResponse response,
                         @RequestParam(value = "id") Long id) {
        try {
            String url = videoAssetService.url(id);
            if (StringUtils.isNotBlank(url)) {
                saveImg(url, response);
            }
        } catch (Exception e) {
            LOGGER.error("查找拒绝原因列表出错", e.getMessage());
        }
    }


    public static void saveImg(String imgUrl, HttpServletResponse response) {
        try {
            //建立URL连接
            URL url = new URL(imgUrl);
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(2 * 1000);
            InputStream inStream = conn.getInputStream();
            byte[] data = readInputStream(inStream);
            String fileName = getImgFileName(imgUrl);
            response.setHeader("Content-disposition", "attachment;filename= " + fileName);
            OutputStream outStream = response.getOutputStream();
            outStream.write(data);
            outStream.flush();
            outStream.close();
        } catch (Exception e) {
            LOGGER.error("下载出错", e.getMessage());
        }
    }

    public static byte[] readInputStream(InputStream inStream) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, len);
        }
        inStream.close();
        // 把outStream里的数据写入内存
        return outStream.toByteArray();
    }

    /**
     * 根据url获取图片的路径
     */
    public static String getImgPath(String imgUrl) {
        return imgUrl.substring(imgUrl.indexOf("n/") + 1, imgUrl.lastIndexOf("/"));
    }

    /**
     * 根据url获取图片的名称
     */
    public static String getImgFileName(String imgUrl) {
        return imgUrl.substring(imgUrl.lastIndexOf("/") + 1);
    }
}
