package com.bxm.adsmanager.web.controller.common;

import com.bxm.adsmanager.model.dto.InfoActivityMsgDto;
import com.bxm.adsmanager.service.datapark.DataparkActivityService;
import com.bxm.util.dto.ResultModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * Created by wuwenquan on 2018/6/21.
 */

@RestController
public class ActivityMsgController {

    private static final Logger LOGGER = LoggerFactory.getLogger(ActivityMsgController.class);

    @Autowired
    private DataparkActivityService  dataparkActivityService;

    @RequestMapping(value = "/findActivityAll", method = RequestMethod.GET)
    public ResultModel<List<InfoActivityMsgDto>> findMediaAll(String keyWords,String activityType,String activityPlan) {
        ResultModel<List<InfoActivityMsgDto>> rs = new ResultModel<>();
        try {
            rs.setReturnValue(dataparkActivityService.getActivityMsg(keyWords,activityType,activityPlan));
        } catch (Exception e) {
            LOGGER.error("活动信息列表查询错误"+e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("活动信息列表查询错误");
        }
        return rs;
    }


}
