package com.bxm.adsmanager.web.controller.common;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */


import com.alibaba.fastjson.JSON;
import com.bxm.acl.facade.AclUserService;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdTicketMapperExt;
import com.bxm.adsmanager.integration.acl.AclUserIntegration;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.adsmedia.provider.ProviderFacadeIntegration;
import com.bxm.adsmanager.model.constant.RedisKeys;
import com.bxm.adsmanager.model.dao.common.Dictionaries;
import com.bxm.adsmanager.model.vo.AdTicketVo;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.redis.RedisClient;
import com.bxm.adsmanager.service.adposition.AdPositionAuditService;
import com.bxm.adsmanager.service.agencychannel.AgencyChannelService;
import com.bxm.adsmanager.service.common.DictionariesService;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.bxm.util.dto.ErrorCode;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * <h3>字典控制器</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2017/12/14 11:24
 */
@RestController
@RequestMapping("/common")
public class DictionariesController {

	private static final Logger LOGGER = LoggerFactory.getLogger(DictionariesController.class);

	@Autowired
	private DictionariesService dictionariesService;

	@Autowired
	private AdPositionAuditService adPositionAuditService;

	@Resource
	private AclUserIntegration aclUserIntegration;

	@Resource
	private AclUserService aclUserService;
    @Autowired
    private JedisUpdater jedisUpdater;
    @Autowired
	private RedisClient redisClient;

    @Autowired
    private AdTicketMapperExt adTicketMapperExt;
	@Autowired
    private AgencyChannelService agencyChannelService;
	 /**
     * app提供接口
     */
    @Autowired
    private ProviderFacadeIntegration providerFacadeIntegration;
    
    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;

	/**
	 * @description 根据字典id查找所有字典
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@RequestMapping(value = "/findAll", method = RequestMethod.GET)
	public ResultModel<Pagination> findAll(String typegroupid) {

		ResultModel rs = new ResultModel();

		try {
			if(typegroupid==null){
				rs.setSuccessed(false);
				rs.setErrorCode(ErrorCode.ILLEGAL_PARAMS.getErrorCode());
				rs.setErrorDesc("typegroupid不可以为空");
				return rs;
			}
			List<Dictionaries>  list = dictionariesService.findAll(typegroupid);

			rs.setReturnValue(list);
		}catch (Exception e){
			LOGGER.error("根据字典id查找所有字典出错"+e.getMessage(), e);
			rs.setSuccessed(false);
			rs.setErrorCode(ErrorCode.SERVER_ERROR.getErrorCode());
			rs.setErrorDesc(ErrorCode.SERVER_ERROR.getErrorMessage());
		}
		return  rs;
	}

	/**
	 * 根据roleCode查询用户
	 */
	@RequestMapping(value = "/findUsersByRoleCode", method = RequestMethod.GET)
	public ResultModel<List<Dictionaries>> findUsersByRoleCode(@RequestParam String roleCode
			, @RequestParam(value = "onlyShowEnable", required = false) Boolean onlyShowEnable) {

		ResultModel<List<Dictionaries>> rs = new ResultModel<>();

		try {
			if(StringUtils.isBlank(roleCode)) {
				rs.setSuccessed(false);
				rs.setErrorCode(ErrorCode.ILLEGAL_PARAMS.getErrorCode());
				rs.setErrorDesc("roleCode不可以为空");
				return rs;
			}
			// 为了前端适配,保持原有返回对象不变
            Map<String, String> roles = aclUserIntegration.queryUserByRoleCode(roleCode, onlyShowEnable);
			List<Dictionaries> dictionaries = Lists.newArrayList();
			int i = 0;
            for (String code : roles.keySet()) {
                Dictionaries dictionary = new Dictionaries();
                dictionary.setId(i+++"");
                dictionary.setTypecode(code);
                dictionary.setTypename(roles.get(code));
                dictionaries.add(dictionary);
            }
			rs.setReturnValue(dictionaries);
		}catch (Exception e){
			LOGGER.error("根据roleCode查找所有用户出错", e);
			rs.setSuccessed(false);
			rs.setErrorCode(ErrorCode.SERVER_ERROR.getErrorCode());
			rs.setErrorDesc(ErrorCode.SERVER_ERROR.getErrorMessage());
		}
		return  rs;
	}
	
	/**
	    * @Title: getProviderAppCodeName
	    * @Description: 获取媒体代号
	    * @return ResultModel<Map<String,String>>
	     */
	    @RequestMapping(value = "/media/getProviderAppCodeName", method = RequestMethod.GET)
	    public ResultModel<Map<String,String>> getProviderAppCodeName(HttpServletRequest request) {
	        ResultModel<Map<String,String>> resultModel = new ResultModel<>();
	        resultModel.setReturnValue(providerFacadeIntegration.getProviderAppCodeName(null));
	        return resultModel;
	    }
	    
	    /**
	     * @Title: getProviderAppWithCodeName
	     * @Description: 获取appKey-媒体代码
	     * @return ResultModel<Map<String,String>>
	      */
	     @RequestMapping(value = "/media/getProviderAppWithCodeName", method = RequestMethod.GET)
	     public ResultModel<Map<String,String>> getProviderAppWithCodeName(HttpServletRequest request) {
	         ResultModel<Map<String,String>> resultModel = new ResultModel<>();
	         resultModel.setReturnValue(providerFacadeIntegration.getProviderAppWithCodeName(null));
	         return resultModel;
	     }
	    
	    /**
	     * @Title: getAppEntranceCodeName
	     * @Description: 获取广告位代号
	     * @return ResultModel<Map<String,String>>
	      */
	     @RequestMapping(value = "/media/getAppEntranceCodeName", method = RequestMethod.GET)
	     public ResultModel<Map<String,String>> getAppEntranceCodeName(HttpServletRequest request) {
	         ResultModel<Map<String,String>> resultModel = new ResultModel<>();
	         resultModel.setReturnValue(newAppEntranceFacadeIntegration.getAppEntranceCodeName());
	         return resultModel;
	     }

	/*//订正数据专用
	@RequestMapping(value = "/correctData", method = RequestMethod.GET, produces = "application/json")
	public ResultModel<Boolean> correctData(){
		ResultModel resultModel = new ResultModel<>();
		adPositionAuditService.correctData();
		return resultModel;
	}*/

	//订正广告位代号数据
    @RequestMapping(value = "/correctPositionCodeData", method = RequestMethod.GET, produces = "application/json")
    public ResultModel correctData() throws Exception{
        ResultModel resultModel = new ResultModel<>();
        long startTime = System.currentTimeMillis();
        QueryAppEntranceParamDTO paramDTO = new QueryAppEntranceParamDTO();
        //查询无论是否审核过的广告位信息
        paramDTO.setStatus(null);
        Map<String, String> appEntranceCodeMap = newAppEntranceFacadeIntegration.getAppEntranceCodeMap(paramDTO);
        for (Map.Entry<String,String> entry : appEntranceCodeMap.entrySet()) {
            String positionId = entry.getKey();
            String value = entry.getValue();
            jedisUpdater.hupdate(RedisKeys.getPositionCodeKey(),positionId,value);
        }
        LOGGER.info("订正广告位代号数据一共花了" + (System.currentTimeMillis()-startTime) + "毫秒");
        return resultModel;
    }


    //订正拼多多广告券数据
    @RequestMapping(value = "/correctPddTicketData", method = RequestMethod.GET, produces = "application/json")
    public ResultModel correctPddTicketData() throws Exception{
        ResultModel resultModel = new ResultModel<>();
        long startTime = System.currentTimeMillis();
        List<AdTicketVo> tickets = adTicketMapperExt.findTicketIdsByAdvertiserId(RedisKeys.advertisers);
        if(CollectionUtils.isNotEmpty(tickets)){
            for(AdTicketVo param :tickets){
                jedisUpdater.hupdate(RedisKeys.getPddTickets(),String.valueOf(param.getId()),param.getAdvertiser());
            }
        }
        LOGGER.info("订正广告券数据一共花了" + (System.currentTimeMillis()-startTime) + "毫秒");
        return resultModel;
    }

	/** 订正广告主自助建站相关广告主 */
	@RequestMapping(value = "/correctOwnSiteAdvertiserData", method = RequestMethod.GET, produces = "application/json")
	public ResultModel correctOwnSiteAdvertiserData(){
		String advertiserIds = "133,179,256,472,476,526,631,675,696,704,1109,1131,1143,1152,1156,1159,1186,1225,1279,1287,1288,1301,1312,1314,1363,1364,1383,1437,1440,1445,1448,1455,1458,1464,1496,1580,1675,1680,1732,1757,1788,1795,1842,1843,1844,1959,2057,2060,2097,2103,2129,2130,2131,2148,2176,2206,2301,2360,2361,2368,2377,2395,2397,2402,2407,2416,2425,2436,2437,2438,2442,2996";
    	ResultModel resultModel = new ResultModel<>();
		String[] array = advertiserIds.split(",");
		List<String> list = Arrays.asList(array);
		for (String advertiser:list){
			List<String> templates = Lists.newArrayList();
			templates.add("wz-model");
			//String json = JSON.toJSONString(templates);
			//redisClient.hset("ADVERTISER:OWN_SITE_TEMPLATE",advertiser,json,4,null);
			jedisUpdater.hupdateWithSelector(RedisKeys.getOwnSiteAdvertiser(),advertiser,templates,4);
		}
		return resultModel;
    }

	@RequestMapping(value = "/dsp/getProductName", method = RequestMethod.GET)
	public ResultModel<List<String>> getProductName() {
		ResultModel<List<String>> resultModel = new ResultModel<>();
		resultModel.setReturnValue(agencyChannelService.getProductNameList());
		return resultModel;
	}

}
