package com.bxm.adsmanager.web.controller.common;

import com.bxm.adsmanager.ecxeption.ExcelException;
import com.bxm.adsmanager.model.dto.LandUserPageParamsDTO;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.service.common.LandUserInfoService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

/**
 * 文 件 名 :
 * CopyRright (c) 2008-xxxx:
 * 文件编号：
 * 创 建 人： hxpeng
 * 日 期： 2018/7/16 15:46
 * 修 改 人：
 * 日 期：
 * 描 述：落地页数据控制层
 * 版 本 号： v1
 */
@RestController
@RequestMapping("/common/landUser")
public class LandUserInfoController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(LandUserInfoController.class);

    @Autowired
    private LandUserInfoService landUserInfoService;

    /**
     * Description: 查询落地用户数据分页
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/7/16 16:36
     */
    @RequestMapping(value = "/findAll", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<Pagination> findAll(LandUserPageParamsDTO paramsDTO) {
        ResultModel<Pagination> resultModel = new ResultModel<>();
        Pagination pagination;
        try {
            pagination = landUserInfoService.findAll(paramsDTO);
        } catch (Exception e) {
            LOGGER.error("查询落地页用户数据异常， error:" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("查询落地页用户数据异常！");
        }
        resultModel.setReturnValue(pagination);
        return resultModel;
    }

    /**
     * Description: 落地页面用户数据导出
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/7/17 14:42
     */
    @RequestMapping(value = "/export", method = RequestMethod.GET)
    public void export(HttpServletResponse response, LandUserPageParamsDTO paramsDTO) throws ExcelException {
        landUserInfoService.export(response, paramsDTO);
    }

}
