package com.bxm.adsmanager.web.controller.common;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.dal.mapper.rtb.PositionRtbMapper;
import com.bxm.adsmanager.dal.mapper.rtb.RtbCvrControlMapper;
import com.bxm.adsmanager.dal.mapper.rtb.RtbRatioControlMapper;
import com.bxm.adsmanager.dal.mapper.rtb.RtbSpeedControlMapper;
import com.bxm.adsmanager.model.dao.rtb.*;
import com.bxm.adsmanager.service.rtb.PositionRTBService;
import com.bxm.util.StringUtil;
import com.google.common.collect.Sets;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.integration.adsmedia.appentrance.InspireVideoFacadeIntegration;
import com.bxm.adsmanager.integration.adsmedia.media.MediaCommonConfigFacadeIntegration;
import com.bxm.adsmanager.model.dao.agencychannel.AgencyChannel;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AgencyChannelDTO;
import com.bxm.adsmanager.model.dto.AgencyChannelSearchDTO;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.model.vo.media.MediaTicketVo;
import com.bxm.adsmanager.service.adposition.AdPositionAuditService;
import com.bxm.adsmanager.service.agencychannel.AgencyChannelService;
import com.bxm.adsmanager.service.common.DictionariesService;
import com.bxm.adsmanager.service.media.MediaTicketTagService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmedia.facade.model.positionclasstype.PositionClassTypeDto;
import com.bxm.adsmedia.facade.model.positionclasstype.PositionClassTypeRo;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;

import lombok.extern.slf4j.Slf4j;

/**
 * @author wangchao
 * @description 媒体相关公共类
 * @date 2018/12/12 14:49
 */

@RestController
@RequestMapping("/common")
@Slf4j
public class MediaCommonController {

    @Autowired
    private MediaCommonConfigFacadeIntegration mediaCommonConfigFacadeIntegration;
    @Autowired
    private InspireVideoFacadeIntegration inspireVideoFacadeIntegration;

    @Autowired
    private DictionariesService dictionariesService;
    @Autowired
    private AdPositionAuditService adPositionAuditService;

    @Autowired
    private MediaTicketTagService mediaTicketTagService;
    @Autowired
    private AgencyChannelService agencyChannelService;
    @Autowired
    private PositionRtbMapper positionRtbMapper;
    @Autowired
    private RtbRatioControlMapper rtbRatioControlMapper;
    @Autowired
    private RtbCvrControlMapper rtbCvrControlMapper;
    @Autowired
    private PositionRTBService positionRTBService;

    /**
     * @param parentId 父ID
     * @param typeCode 所属分类
     * @param name     标签名称
     * @return ResultModel<List < PositionClassType>>
     * @Title: queryPositionClassTypeList
     * @Description: 查询媒体相关配置列表(前端下拉框使用)
     */
    @RequestMapping(value = "/mediaConfigList", method = RequestMethod.GET)
    public ResultModel<List<PositionClassTypeRo>> queryPositionClassTypeList(
            @RequestParam(value = "parentId", required = false, defaultValue = "0") Long parentId,
            @RequestParam(value = "typeCode") String typeCode,
            @RequestParam(value = "name", required = false) String name) {
        PositionClassTypeDto param = new PositionClassTypeDto();
        param.setParentId(parentId);
        param.setTypeCode(typeCode);
        param.setName(name);
        return mediaCommonConfigFacadeIntegration.queryPositionClassTypeList(param);
    }

    /**
     * 订正数据接口，将app_entrance表中的video_direction迁移至app_entrance_inspire_video_config表
     * @param
     * @return com.bxm.util.dto.ResultModel<java.lang.Boolean>
     * @author tangx
     * @DATE 2019/9/26 10:02
     */
    @RequestMapping(value = "/updateAppEntranceData", method = RequestMethod.GET)
    public ResultModel<Boolean> updateAppEntranceData() {
        return inspireVideoFacadeIntegration.updateAppEntranceData("bxm_channel");
    }

    ///**
    // * 订正数据接口，warcar里面存储的广告位小程序白名单数据迁移到新的key中
    // * 迁移完成，代码屏蔽
    // * @param
    // * @return com.bxm.util.dto.ResultModel<java.lang.Boolean>
    // * @author zhengwangeng
    // * @time 2021/5/11
    // */
    //@RequestMapping(value = "/updateWechatMiniAppPutInfo", method = RequestMethod.GET)
    //public ResultModel<Boolean> updateWechatMiniAppPutInfo(String []positionIds) {
    //    ResultModel rs = new ResultModel<Boolean>();
    //    StringBuffer stringBuffer = new StringBuffer();
    //    for (String positionId : positionIds) {
    //        try {
    //            adPositionAuditService.updateWechatMiniAppPutInfo(positionId, Boolean.TRUE, "admin");
    //        } catch (Exception e) {
    //            stringBuffer.append(positionId + " 同步失败。");
    //        }
    //    }
    //    rs.setReturnValue(true);
    //    if (stringBuffer.length() > 0){
    //        rs.setReturnValue(false);
    //        rs.setErrorDesc(stringBuffer.toString());
    //    }
    //    return rs;
    //}


    /**
     * @description
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param request
     * @param response
     * @return com.bxm.util.dto.ResultModel
     */
    @RequestMapping(value = "/findTicketByParam", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<PageInfo<MediaTicketVo>> findTicketByParam(HttpServletRequest request, HttpServletResponse response,
                                                                  @RequestParam(value = "pageNum",required = false,defaultValue = "1") Integer pageNum,
                                                                  @RequestParam(value = "pageSize",required = false,defaultValue = "20") Integer pageSize,
                                                                  @RequestParam(value = "keywords",required = false  ) String keywords,
                                                                  @RequestParam(value = "ids",required = false  ) String ids,
                                                                  @RequestParam(value = "type",required = true  ,defaultValue = "1") String type,
                                                                  @RequestParam(value = "parentId",required = false  ) String parentId,
                                                                  @RequestParam(value = "childId",required = false  ) String childId,
                                                                  @RequestParam(value = "statusCode",required = false) String statusCode,
                                                                  @RequestParam(value = "positionId" ,required = false ) String positionId) throws Exception{
        ResultModel<PageInfo<MediaTicketVo>> rs = new ResultModel<PageInfo<MediaTicketVo>>();
        try {

            PageInfo<MediaTicketVo> result = mediaTicketTagService.findTicketByParam(keywords,pageNum,pageSize,ids, type,parentId,statusCode,positionId,childId);
            if (result != null) {
                rs.setReturnValue(result);
            }
        } catch (Exception e) {
            log.error("媒体查找广告券列表出错:" + e.getMessage() + ",queryString=" + request.getQueryString(), e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
        return rs;
    }


    /**
     * 订正渠道字典数据接口
     * 迁移完成，代码屏蔽
     * @param
     * @return com.bxm.util.dto.ResultModel<java.lang.Boolean>
     * @author zhengwangeng
     * @time 2022/5/17
     */
    @RequestMapping(value = "/updateAgencyChannelInfo", method = RequestMethod.GET)
    public ResultModel<Boolean> updateAgencyChannelInfo() {
        ResultModel rs = new ResultModel<>();
        HashSet<Long> ids = new HashSet<>();
        try {
            AgencyChannelSearchDTO searchDto = new AgencyChannelSearchDTO();
            searchDto.setProductName("淘宝");
            List<AgencyChannel> all = agencyChannelService.getList(searchDto);
            //链接中包含“1763656536”，修改产品名称为“淘宝-留存（天天特卖）”
            //
            //“2089633783”修改产品名称为“淘宝-促活定向（ROI）”
            //
            //“1981891941”修改产品名称为“淘宝-促活优选”
            //
            //“32896”修改产品名称为“淘宝-促活定向”
            //
            //“32768”修改产品名称为“淘宝-促活通投”

            if (CollectionUtils.isNotEmpty(all)) {
                for (AgencyChannel agencyChannel : all) {
                    String linkUrl = agencyChannel.getLinkUrl();
                    if (linkUrl.contains("1763656536")) {
                        agencyChannel.setProductName("淘宝-留存（天天特卖）");
                    } else if (linkUrl.contains("2089633783")) {
                        agencyChannel.setProductName("淘宝-促活定向（ROI）");
                    } else if (linkUrl.contains("1981891941")) {
                        agencyChannel.setProductName("淘宝-促活优选");
                    } else if (linkUrl.contains("32896")) {
                        agencyChannel.setProductName("淘宝-促活定向");
                    } else if (linkUrl.contains("32768")) {
                        agencyChannel.setProductName("淘宝-促活通投");
                    } else{
                        log.info(String.valueOf(agencyChannel.getId()));
                        continue;
                    }
                    ids.add(agencyChannel.getId());
                    AgencyChannelDTO agencyChannelDTO = new AgencyChannelDTO();
                    BeanUtils.copyProperties(agencyChannel, agencyChannelDTO);
                    User user = new User();
                    user.setRoleCodes(Lists.newArrayList(RoleEnum.CHAN_PIN_LEADER.getCode()));
                    agencyChannelService.update(agencyChannelDTO, user);
                }
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        rs.setReturnValue(ids);
        return rs;
    }

    @RequestMapping(value = "/updateAgencyChannelMd5Info", method = RequestMethod.GET)
    public ResultModel<Boolean> updateAgencyChannelMd5Info() {
        ResultModel rs = new ResultModel<>();
        HashSet<Long> ids = new HashSet<>();
        try {
            AgencyChannelSearchDTO searchDto = new AgencyChannelSearchDTO();
            List<AgencyChannel> all = agencyChannelService.getList(searchDto);
            if (CollectionUtils.isNotEmpty(all)) {
                for (AgencyChannel agencyChannel : all) {
                    ids.add(agencyChannel.getId());
                    AgencyChannelDTO agencyChannelDTO = new AgencyChannelDTO();
                    BeanUtils.copyProperties(agencyChannel, agencyChannelDTO);
                    User user = new User();
                    user.setRoleCodes(Lists.newArrayList(RoleEnum.CHAN_PIN_LEADER.getCode()));
                    agencyChannelService.update(agencyChannelDTO, user);
                }
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        rs.setReturnValue(ids);
        return rs;
    }

}
