package com.bxm.adsmanager.web.controller.common;

import com.bxm.adsmanager.model.dto.InfoMediaMsgDto;
import com.bxm.adsmanager.model.dto.InfoPositionMsgDto;
import com.bxm.adsmanager.model.dto.common.CommonSearchDto;
import com.bxm.adsmanager.service.adposition.AdPositionAuditService;
import com.bxm.adsmanager.service.common.MediaPositionService;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**  
* @Title: MediaPositionController 
* @Description: 获取媒体和广告位的信息 
* @author xavier  
* @date 2018年3月14日  
*/  
@RequestMapping("/mediaPosition")
@RestController
public class MediaPositionController extends BaseController {
	
	private static final Logger LOGGER = LoggerFactory.getLogger(MediaPositionController.class);
	
	@Autowired
	private MediaPositionService mediaPositionService;
	
	/**  
	 * 根据角色来查找对应的媒体信息列表
	 * @author yirenjie
	 * @date 2018年7月20日
	 */  
	@RequestMapping(value = "/findMediaByRole", method = RequestMethod.GET)
	public ResultModel<List<InfoMediaMsgDto>> findMediaByRole(CommonSearchDto search
			, HttpServletRequest request, HttpServletResponse response) {
		ResultModel<List<InfoMediaMsgDto>> rs = new ResultModel<List<InfoMediaMsgDto>>();
		try {
			rs.setReturnValue(mediaPositionService.findMediaByRole(getUser(request, response), search));
		} catch (Exception e) {
			LOGGER.error("媒体信息列表查询错误"+e.getMessage(), e);
			rs.setSuccessed(false);
			rs.setErrorDesc("媒体信息列表查询错误");
		}
		return rs;
	}

	/**
	 * 根据角色来查找对应的媒体信息列表
	 * @author yirenjie
	 * @date 2018年7月20日
	 */
	@RequestMapping(value = "/findPositionByRole", method = RequestMethod.GET)
	public ResultModel<List<InfoPositionMsgDto>> findPositionByRole(CommonSearchDto search
			, HttpServletRequest request, HttpServletResponse response) {
		ResultModel<List<InfoPositionMsgDto>> rs = new ResultModel<>();
		try {
			rs.setReturnValue(mediaPositionService.findPositionByRole(getUser(request, response), search));
		} catch (Exception e) {
			LOGGER.error("媒体信息列表查询错误"+e.getMessage(), e);
			rs.setSuccessed(false);
			rs.setErrorDesc("媒体信息列表查询错误");
		}
		return rs;
	}

	/**
	 * @Title: findAll
	 * @Description:  通过APPKEY 和  关键字查询媒体信息列表
	 * @author xavier
	 * @date 2018年3月14日
	 */
	@RequestMapping(value = "/findMediaAll", method = RequestMethod.GET)
	public ResultModel<List<InfoMediaMsgDto>> findMediaAll(CommonSearchDto search) {
		ResultModel<List<InfoMediaMsgDto>> rs = new ResultModel<List<InfoMediaMsgDto>>();
		try {
			rs.setReturnValue(mediaPositionService.findMediaAll(search));
		} catch (Exception e) {
			LOGGER.error("媒体信息列表查询错误"+e.getMessage(), e);
			rs.setSuccessed(false);
			rs.setErrorDesc("媒体信息列表查询错误");
		}
		return rs;
	}
	
	/**
	 * @Title: findAll
	 * @Description:  通过APPKEY 和关键字查询广告位信息列表
	 * @author xavier
	 * @date 2018年3月14日
	 */
	@RequestMapping(value = "/findPositionAll", method = RequestMethod.GET)
	public ResultModel<List<InfoPositionMsgDto>> findPositionAll(CommonSearchDto search) {
		ResultModel<List<InfoPositionMsgDto>> rs = new ResultModel<List<InfoPositionMsgDto>>();
		try {
			if (StringUtils.isEmpty(search.getAppKey())) {
				rs.setSuccessed(false);
				rs.setErrorDesc("请选择需要查询的广告位");
				return rs;
			}
			rs.setReturnValue(mediaPositionService.findPositionAll(search));
		} catch (Exception e) {
			LOGGER.error("广告位信息列表查询错误"+e.getMessage(), e);
			rs.setSuccessed(false);
			rs.setErrorDesc("广告位信息列表查询错误");
		}
		return rs;
	}





	/**
	 * @Title: findAll
	 * @Description:  通过APPKEY 和关键字查询广告位信息列表
	 * @author xavier
	 * @date 2018年3月14日
	 */
	@RequestMapping(value = "/findPositionAll2", method = RequestMethod.GET)
    public ResultModel<List<InfoPositionMsgDto>> findPositionAll(String appKeys, String keyWords) {
        ResultModel<List<InfoPositionMsgDto>> rs = new ResultModel<>();
        try {
            List<String> appKeyList = null;
            if (StringUtils.isNotBlank(appKeys)) {
                String[] appKeysArray = appKeys.split(",");
                if (appKeysArray.length > 0) {
                    appKeyList = Arrays.asList(appKeysArray);
                }
            } else {
                appKeyList = Collections.emptyList();
            }
            rs.setReturnValue(mediaPositionService.findAllPositionByAppkeysAndKeywords(appKeyList, keyWords));
        } catch (Exception e) {
            LOGGER.error("广告位信息列表查询错误" + e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("广告位信息列表查询错误");
        }
        return rs;
    }


	/**
	 * 根据 参数查询 广告位列表(appkey 可不传)
	 * @param search
	 * @return
	 */
	@RequestMapping(value = "/findPositionAllByparam",method = RequestMethod.GET)
	public ResultModel<List<InfoPositionMsgDto>> findPositionAllList(CommonSearchDto search){
		ResultModel<List<InfoPositionMsgDto>> rs = new ResultModel<List<InfoPositionMsgDto>>();
		try {
			rs.setReturnValue(mediaPositionService.findPositionAll(search));
		} catch (Exception e) {
			LOGGER.error("广告位信息列表查询错误"+e.getMessage(), e);
			rs.setSuccessed(false);
			rs.setErrorDesc("广告位信息列表查询错误");
		}
		return rs;
	}
}
