package com.bxm.adsmanager.web.controller.common;

import com.bxm.adsmanager.service.prod.ProdService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <h3>Shenjue.java基本描述</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/10/30 16:39
 */
@RequestMapping("/common")
@RestController
@Slf4j
public class PushRedisController {

	@Autowired
	private ProdService prodService;

	@RequestMapping("/pushAdTicket")
	public ResultModel pushTicket(Long id){
		try {
			prodService.pushAdTicketToProdPre(id);
		}catch (Exception e){
			log.error(e.getMessage(),e);
			return ResultModelFactory.FAIL();
		}
		return ResultModelFactory.SUCCESS();
	}
}
