package com.bxm.adsmanager.web.controller.dictionary;

import com.bxm.adsmanager.model.dao.common.Dictionaries;
import com.bxm.adsmanager.model.dao.common.DictionaryGroup;
import com.bxm.adsmanager.service.common.DictionariesService;
import com.bxm.util.dto.ResultModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**数据字典服务
 * @author sunzs
 * created on 2018/10/10
 */
@RestController
@RequestMapping("/dictionary")
public class DictionaryController {

    @Autowired
    private DictionariesService dictionariesService;

    /**
     *
     * 功能描述:查询父类字点列表
     * @fileName:
     * @param: [keyword, pageNum, pageSize]
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2018/10/10 16:09
     */
    @RequestMapping(value = "/findDictionaryGroup",method = RequestMethod.GET)
    public ResultModel findDictionaryGroup(@RequestParam("keyword")String keyword,
                                           @RequestParam(value = "pageNum",defaultValue = "1")Integer pageNum,
                                           @RequestParam( value = "pageSize",defaultValue = "20")Integer pageSize){

        return dictionariesService.findDictionaryGroup(keyword,pageNum,pageSize);
    }

    /**
     *  父类字典新增
     * 功能描述:
     * @fileName:
     * @param: [typeGroupCode, typeGroupName]
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2018/10/10 14:36
     */
    @RequestMapping(value = "/add",method = RequestMethod.POST)
    public ResultModel add(DictionaryGroup dictionaryGroup){

        return dictionariesService.insertTypeGroup(dictionaryGroup);
    }

    /**
     *
     * 功能描述:
     * @fileName:删除父类字典，如果子类字典不为空不让删
     * @param: [id]
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2018/10/10 16:32
     */
    @RequestMapping(value = "/delete",method = RequestMethod.GET)
    public ResultModel delete(@RequestParam("id")String id){

        return dictionariesService.deleteTypeGroup(id);
    }

    /**
     *
     * 功能描述:
     * @fileName:修改父类字典
     * @param: [dictionaryGroup]
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2018/10/10 17:05
     */
    @RequestMapping(value = "/update",method = RequestMethod.POST)
    public ResultModel update(DictionaryGroup dictionaryGroup){

        return dictionariesService.updateTypeGroup(dictionaryGroup);
    }

    /**
     *
     * 功能描述: 子类字典查询
     * @fileName:
     * @param: [typegroupid, pageNum, pageSize]
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2018/10/11 9:47
     */
    @RequestMapping(value = "/findDictionary",method = RequestMethod.GET)
    public ResultModel findDictionary(@RequestParam("typeGroupId")String typeGroupId,
                                      @RequestParam("keyword")String keyword,
                                      @RequestParam(value = "pageNum",defaultValue = "1")Integer pageNum,
                                      @RequestParam(value = "pageSize",defaultValue = "20")Integer pageSize){

        return dictionariesService.findDictionary(typeGroupId,pageNum,pageSize,keyword);
    }

    /**
     *
     * 功能描述: 子类字典查询
     * @fileName:
     * @param: [typegroupid, pageNum, pageSize]
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2018/10/11 9:47
     */
    @RequestMapping(value = "/findDictionaryGroupNoPage",method = RequestMethod.GET)
    public ResultModel findDictionary(@RequestParam("typeGroupCode")String typeGroupCode){

        return dictionariesService.findDictionaryNoPage(typeGroupCode);
    }


    /**
     *
     * 功能描述: 子类字典添加
     * @fileName:
     * @param: [dictionaries]
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2018/10/10 17:09
     */
    @RequestMapping(value = "/addDictionary",method = RequestMethod.POST)
    public ResultModel addDictionary(Dictionaries dictionaries){

        return dictionariesService.addDictionary(dictionaries);
    }

    /**
     *
     * 功能描述:
     * @fileName:子类字典修改
     * @param: [dictionaries]
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2018/10/11 10:57
     */
    @RequestMapping(value = "/updateDictionary",method = RequestMethod.POST)
    public ResultModel updateDictionary(Dictionaries dictionaries){

        return dictionariesService.updateDictionary(dictionaries);
    }

    /**
     *
     * 功能描述:
     * @fileName:子类字典删除
     * @param: [id]
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2018/10/11 11:23
     */
    @RequestMapping(value = "/deleteDictionary",method = RequestMethod.GET)
    public ResultModel deleteDictionary(@RequestParam("id") String id){

        return dictionariesService.deleteDictionary(id);
    }


}
