package com.bxm.adsmanager.web.controller.diysite;

import com.bxm.adsmanager.model.dao.common.Dictionaries;
import com.bxm.adsmanager.model.dao.diysite.SiteInstanceDao;
import com.bxm.adsmanager.model.dao.diysite.SiteInstanceDto;
import com.bxm.adsmanager.model.dao.diysite.SiteTemplateDao;
import com.bxm.adsmanager.model.dao.diysite.SiteTemplateDto;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.service.diysite.SiteInstanceService;
import com.bxm.adsmanager.service.diysite.SiteTemplateService;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ErrorCode;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 自建站相关controller
 *
 * @author  bcc
 */
@RestController
@RequestMapping("/diysite")
public class DIYSiteContoller extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(DIYSiteContoller.class);

    @Autowired
    private SiteTemplateService siteTemplateService;

    @Autowired
    private SiteInstanceService siteInstanceService;

    @RequestMapping("/getTemplates")
    public ResultModel getTemplates(SiteInstanceDto dto){
        ResultModel rs = new ResultModel();
        try {
            Map<String,List<SiteTemplateDao>> all = siteTemplateService.findAll(dto);
            rs.setReturnValue(all);
        }catch (Exception e){
            rs.setSuccessed(Boolean.FALSE);
            LOGGER.error("getTemplates Error",e);
        }
        return rs;
    }

    @RequestMapping(value = "/findAllTemplate",method = RequestMethod.GET)
    public ResultModel findAllTemplate(SiteTemplateDto dto){
        ResultModel rs = new ResultModel();
        try {
            PageInfo<SiteTemplateDao> all = siteTemplateService.findTemplate(dto);
            rs.setReturnValue(all);
        }catch (Exception e){
            rs.setSuccessed(Boolean.FALSE);
            LOGGER.error("findAllTemplate Error",e);
        }
        return rs;

    }



    @RequestMapping("/findAll")
    public ResultModel findAll(SiteInstanceDto dto){
        ResultModel rs = new ResultModel();
        try {
            PageInfo<SiteInstanceDao> all = siteInstanceService.findAll(dto);
            rs.setReturnValue(all);
        }catch (Exception e){
            rs.setSuccessed(Boolean.FALSE);
            LOGGER.error("findAll Error",e);
        }
        return rs;
    }

    @LogBefore(operType = "/diysite/add", keyName = "新增自建站")
    @RequestMapping(value = "/add", produces = "application/json")
    public ResultModel add(SiteInstanceDto dto, HttpServletRequest request, HttpServletResponse response){
        User user = getUser(request,response);

        ResultModel rs = new ResultModel();
        dto.setId(null);
        try {
            rs.setReturnValue(siteInstanceService.saveOrUpdate(dto,user));
        }catch (Exception e){
            rs.setSuccessed(Boolean.FALSE);
            LOGGER.error("add Error",e);
        }
        return rs;
    }


    @LogBefore(operType = "/diysite/update", keyName = "更新自建站")
    @RequestMapping(value = "/update", produces = "application/json")
    public ResultModel update(SiteInstanceDto dto){
        ResultModel rs = new ResultModel();
        try {
            rs.setReturnValue(siteInstanceService.saveOrUpdate(dto,null));
        }catch (Exception e){
            rs.setSuccessed(Boolean.FALSE);
            LOGGER.error("update Error",e);
        }
        return rs;
    }

    @RequestMapping("/get")
    public ResultModel get(SiteInstanceDto dto){
        ResultModel rs = new ResultModel();
        if(null == dto || null == dto.getId() || dto.getId() <= 0){
            rs.setSuccessed(Boolean.FALSE);
            rs.setErrorCode(ErrorCode.ILLEGAL_PARAMS.getErrorCode());
            rs.setErrorDesc("id不可以为空");
            return rs;
        }
        try {
            rs.setReturnValue(siteInstanceService.getById(dto.getId()));
        }catch (Exception e){
            rs.setSuccessed(Boolean.FALSE);
            LOGGER.error("update Error",e);
        }
        return rs;
    }
    @RequestMapping("/delete")
    public ResultModel delete(SiteInstanceDto dto){
        ResultModel rs = new ResultModel();
        if(null == dto || null == dto.getId() || dto.getId() <= 0){
            rs.setSuccessed(Boolean.FALSE);
            rs.setErrorCode(ErrorCode.ILLEGAL_PARAMS.getErrorCode());
            rs.setErrorDesc("id不可以为空");
            return rs;
        }
        try {
            rs.setReturnValue(siteInstanceService.deleteById(dto.getId()));
        }catch (Exception e){
            rs.setSuccessed(Boolean.FALSE);
            LOGGER.error("update Error",e);
        }
        return rs;
    }


    @RequestMapping("/findCreateUser")
    public ResultModel<List<Dictionaries>> findCreateUser(){
        ResultModel<List<Dictionaries>> resultModel = new ResultModel();
        List<Dictionaries> list = siteInstanceService.findCreateUser();
        resultModel.setReturnValue(list);
        return  resultModel;
    }



}
