package com.bxm.adsmanager.web.controller.diysite;

import com.bxm.adsmanager.model.dao.common.Dictionaries;
import com.bxm.adsmanager.model.dao.diysite.SiteTemplateDto;
import com.bxm.adsmanager.service.diysite.SiteTemplateService;
import com.bxm.util.dto.ResultModel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author sunzs
 * created on 2019/2/27
 */
@RestController
@RequestMapping("/diyTemplate")
@Slf4j
public class DIYTemplateContoller {

    @Autowired
    private SiteTemplateService siteTemplateService;


    @RequestMapping(value = "/add",method = RequestMethod.POST)
    public ResultModel add(SiteTemplateDto dto){

        return siteTemplateService.add(dto);
    }

    @RequestMapping("/delete")
    public ResultModel delete(SiteTemplateDto dto){
        ResultModel resultModel = new ResultModel();
        Boolean result =  siteTemplateService.delete(dto);
        resultModel.setReturnValue(result);
        resultModel.setSuccessed(result);
        return resultModel;
    }

    @RequestMapping("/findTemplateTypes")
    public ResultModel findTemplateTypes(@RequestParam("typeGroupCode")String typeGroupCode){
        ResultModel resultModel = new ResultModel();
        List<Dictionaries> map = siteTemplateService.findTemplateTypes(typeGroupCode);
        resultModel.setReturnValue(map);
        return resultModel;
    }

}
