package com.bxm.adsmanager.web.controller.exclude;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.model.dto.AdAssetsStatisticsDto;
import com.bxm.adsmanager.model.vo.AdAssetsStatisticsVo;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsService;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.utils.UploadImg;
import com.bxm.adsmanager.web.controller.base.ExcludeBaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * @FileName package com.bxm.adsmanager.web.controller.adkeeper.AdTicketController.java
 * @CopyRright (c) 2017-bxm：杭州微财科技有限公司:
 * @Creator hcmony
 * @Created 2017-12-07 16:04:00
 * @Description 参数不受拦截器控制
 */
@RestController
@RequestMapping("/exclude")
public class ExcludeAssetsController extends ExcludeBaseController {

	private static final Logger LOGGER = LoggerFactory.getLogger(ExcludeAssetsController.class);

	@Autowired
	private UploadImg uploadImg;
	
	/**
	 * 素材服务接口
	 */
	@Autowired
    private AdTicketAssetsService adTicketAssetsService;


	/**
	 * @description 添加广告素材图片
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@LogBefore(operType="/exclude/uploadImg",keyName="广告")
	@RequestMapping(value = "/uploadImg", method = RequestMethod.POST)
	public ResultModel uploadImg(HttpServletRequest request, HttpServletResponse response,
								 @RequestParam(required = true, name = "token") String token) {

		ResultModel rs = new ResultModel();
		try {
			boolean result = auth(request,response,token);
			if(!result){
				return ResultModelFactory.FAIL400("用户没有权限");
			}
			//上传图片，使用的方法，地址和老系统一致
			JSONArray urlString = (JSONArray)uploadImg.uploadImg(response, request, "certificate", LOGGER);
			if(urlString!=null){
				JSONObject urlJson =  urlString.getJSONObject(0);
				String url = (String)urlJson.get("url");
				rs.setReturnValue(url);
			}
		}catch (Exception e){
			LOGGER.error("添加添加广告素材图片出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("添加添加广告素材图片出错");
		}
		return  rs;
	}


	/**
	 * @description 批量上传广告素材图片
	 * @author bcc
	 * @time 2018/02/27
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return ResultModel
	 */
	@LogBefore(operType="/exclude/uploadImgMutl",keyName="广告")
	@RequestMapping(value = "/uploadImgMutl", method = RequestMethod.POST)
	public ResultModel uploadImgMutl(HttpServletRequest request, HttpServletResponse response,
								 @RequestParam(required = true, name = "token") String token) {

		ResultModel rs = new ResultModel();
		try {
			boolean result = auth(request,response,token);
			if(!result){
				return ResultModelFactory.FAIL400("用户没有权限");
			}
			//上传图片，使用的方法，地址和老系统一致
			List<String> urls = uploadImg.uploadImgMutl(request, "certificate", LOGGER);
			rs.setReturnValue(urls);
		}catch (Exception e){
			LOGGER.error("批量上传广告素材图片出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("批量上传广告素材图片出错");
		}
		return  rs;
	}
	
	/**
     * @description 导出素材列表数据
     * @CopyRight 杭州微财网络科技有限公司
     */
    @LogBefore(operType="/adAssets/export",keyName="广告券素材")
    @RequestMapping(value = "/adAssets/export", method = RequestMethod.GET)
    public void exportAdAssetsLowClickRateList(HttpServletRequest request, HttpServletResponse response,
            AdAssetsStatisticsDto param,@RequestParam(required = false, name = "token") String token) {
        List<AdAssetsStatisticsVo> lists = null;
        try {
            lists = adTicketAssetsService.exportAdAssetsLowClickRateList(param);
        } catch (Exception e) {
            LOGGER.error("导出素材列表数据出错"+e.getMessage(), e);
            lists = new ArrayList<AdAssetsStatisticsVo>();
        }
        //导出数据
        ExcelUtil.exportExcel(lists, null, "广告素材数据", AdAssetsStatisticsVo.class, "广告素材数据.xls", response);
    }
}
