package com.bxm.adsmanager.web.controller.exclude;

import com.bxm.adsmanager.ecxeption.ProfitException;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.adprofit.AdProfitMediaDto;
import com.bxm.adsmanager.model.dto.adprofit.AdProfitPositionDto;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.model.vo.adprofit.AdProfitMediaVo;
import com.bxm.adsmanager.model.vo.adprofit.AdProfitPositionVo;
import com.bxm.adsmanager.service.adprofit.AdProfitMediaPositionService;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.adsmanager.utils.ExcelUtils;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.ExcludeBaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * <h3>下载excel专用控制器，参数不受拦截器控制</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/03/28 14:06
 */
@RestController
@RequestMapping("/exclude")
public class ExcludeExcelController extends ExcludeBaseController {

	private static final Logger LOGGER = LoggerFactory.getLogger(ExcludeExcelController.class);

	private static final int DEFULT_ONE = 1;

	@Autowired
	private AdProfitMediaPositionService adProfitMediaPositionService;

	/**
	 * @description 下载媒体收益Excel表格
	 * @author hcmony
	 * @time 2018/3/14
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param request
	 * @param response
	 * @param datetime
	 * @return com.bxm.util.dto.ResultModel<com.bxm.adsmanager.model.vo.Pagination>
	 */
	@LogBefore(keyName = "广告",operType = "/exclude/downLoadMedia")
	@RequestMapping(value = "/downLoadMedia", method = RequestMethod.GET)
	public ResultModel downLoadMediaExcel(HttpServletRequest request,
										  HttpServletResponse response,
										  @RequestParam(required = true, name = "datetime") String datetime,
										  @RequestParam(required = true, name = "token") String token){
		try {
			boolean result = auth(request,response,token);
			if(!result){
				return ResultModelFactory.FAIL400("用户没有权限");
			}
			List<AdProfitMediaVo> list = adProfitMediaPositionService.downLoadMedia(datetime);
			//导出操作
			ExcelUtil.exportExcel(list, null, "媒体收益", AdProfitMediaVo.class, "媒体收益"+datetime+".xls", response);
		} catch (Exception e) {
			LOGGER.error("下载媒体收益Excel表格错误"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("下载媒体收益Excel表格错误");
		}
		return ResultModelFactory.SUCCESS();
	}

	/**
	 * @description 下载广告位收益Excel表格
	 * @author hcmony
	 * @time 2018/3/14
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param request
	 * @param response
	 * @param datetime
	 * @return com.bxm.util.dto.ResultModel<com.bxm.adsmanager.model.vo.Pagination>
	 */
	@LogBefore(keyName = "广告",operType = "/exclude/downLoadPosition")
	@RequestMapping(value = "/downLoadPosition", method = RequestMethod.GET)
	public ResultModel downLoadPositionExcel(HttpServletRequest request,
											 HttpServletResponse response,
											 @RequestParam(required = true, name = "datetime") String datetime,
											 @RequestParam(required = false, name = "appId") String appId,
											 @RequestParam(required = true, name = "token") String token){
		try {
			boolean result = auth(request,response,token);
			if(!result){
				return ResultModelFactory.FAIL400("用户没有权限");
			}
			List<AdProfitPositionVo> list = adProfitMediaPositionService.downLoadPosition( datetime,appId);
			//导出操作
			ExcelUtil.exportExcel(list, null, "广告位收益", AdProfitPositionVo.class, "广告位收益"+datetime+".xls", response);
		} catch (Exception e) {
			LOGGER.error("下载广告位收益Excel表格错误"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("下载广告位收益Excel表格错误");
		}
		return ResultModelFactory.SUCCESS();
	}

	/**
	 * @description  导入收益Excel表格
	 * @author hcmony
	 * @time 2018/3/14
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param request
	 * @param response
	 * @return com.bxm.util.dto.ResultModel<com.bxm.adsmanager.model.vo.Pagination>
	 */
	@LogBefore(keyName = "广告",operType = "/exclude/importProfit")
	@RequestMapping(value = "/importProfit", method = RequestMethod.POST)
	public ResultModel<Pagination> importProfitExcel(HttpServletRequest request,
													 HttpServletResponse response,
													 @RequestParam(required = true, name = "token") String token){
		try {
			boolean result = auth(request,response,token);
			if(!result){
				return ResultModelFactory.FAIL400("用户没有权限");
			}
			MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
			Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
			User user = getUser(request, response);
			for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
				MultipartFile file = entity.getValue();// 获取上传文件对象
				// 获得文件名称
				String originalFilename = file.getOriginalFilename();
				if (originalFilename.indexOf("媒体收益")!=-1) {
					LinkedHashMap<String, String> fieldMap = new LinkedHashMap<String, String>();
					fieldMap.put("ID", "id");
					fieldMap.put("日期", "datetime");
					fieldMap.put("媒体ID", "appId");
					fieldMap.put("预估收益", "profitPredict");
					fieldMap.put("实际收益", "profitActual");
					fieldMap.put("备注", "remark");
					List<AdProfitMediaDto> results = ExcelUtils.excelToList(file.getInputStream(),
							"媒体收益", AdProfitMediaDto.class, fieldMap, DEFULT_ONE);
					//ExcelUtil.importExcel(file,DEFULT_ONE,DEFULT_ONE,AdProfitMediaVo.class);
					adProfitMediaPositionService.importProfitMediaExcel(user,results);
					return ResultModelFactory.SUCCESS();
				}else if(originalFilename.indexOf("广告位收益")!=-1){
					LinkedHashMap<String, String> fieldMap = new LinkedHashMap<String, String>();
					fieldMap.put("ID", "id");
					fieldMap.put("日期", "datetime");
					fieldMap.put("广告位ID", "positionId");
					fieldMap.put("媒体ID", "appId");
					fieldMap.put("预估收益", "profitPredict");
					fieldMap.put("扣量金额", "profitDeduct");
					fieldMap.put("备注", "remark");
					List<AdProfitPositionDto> results = ExcelUtils.excelToList(file.getInputStream(),
							"广告位收益", AdProfitPositionDto.class, fieldMap, DEFULT_ONE);
					adProfitMediaPositionService.importAdProfitPositionExcel(user,results);
					return ResultModelFactory.SUCCESS();
				}else {
					return ResultModelFactory.FAIL500("导入失败(表格名称不识别)");
				}
			}
		} catch (ProfitException pe) {
			return ResultModelFactory.FAIL500(pe.getMessage());
		}catch (Exception e) {
			LOGGER.error("导入媒体收益Excel表格错误"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("导入媒体收益Excel表格错误");
		}
		return ResultModelFactory.SUCCESS();
	}


	/**
	 * @description  导入收益Excel表格
	 * @author hcmony
	 * @time 2018/3/14
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param request
	 * @param response
	 * @return com.bxm.util.dto.ResultModel<com.bxm.adsmanager.model.vo.Pagination>
	 */
	@LogBefore(keyName = "广告",operType = "/exclude/importProfitExcelTest")
	@RequestMapping(value = "/importProfitExcelTest", method = RequestMethod.POST)
	public ResultModel<Pagination> importProfitExcelTest(HttpServletRequest request,
													 HttpServletResponse response,
													 @RequestParam(required = true, name = "token") String token){
		try {
			boolean result = auth(request,response,token);
			if(!result){
				return ResultModelFactory.FAIL400("用户没有权限");
			}
			MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
			Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
			User user = getUser(request, response);
			for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
				MultipartFile file = entity.getValue();// 获取上传文件对象
				// 获得文件名称
				String originalFilename = file.getOriginalFilename();
				if (originalFilename.indexOf("媒体收益")!=-1) {
					LinkedHashMap<String, String> fieldMap = new LinkedHashMap<String, String>();
					fieldMap.put("ID", "id");
					fieldMap.put("日期", "datetime");
					fieldMap.put("媒体ID", "appId");
					fieldMap.put("预估收益", "profitPredict");
					fieldMap.put("实际收益", "profitActual");
					fieldMap.put("备注", "remark");
					List<AdProfitMediaDto> results = ExcelUtils.excelToList(file.getInputStream(),
							"媒体收益", AdProfitMediaDto.class, fieldMap, DEFULT_ONE);
					//adProfitMediaPositionService.importProfitMediaExcel(user,results);
					adProfitMediaPositionService.importAdProfitMediaExcel(user,results);
					return ResultModelFactory.SUCCESS();
				}
			}
		} catch (ProfitException pe) {
			return ResultModelFactory.FAIL500(pe.getMessage());
		}catch (Exception e) {
			LOGGER.error("导入媒体收益Excel表格错误"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("导入媒体收益Excel表格错误");
		}
		return ResultModelFactory.SUCCESS();
	}
}
