package com.bxm.adsmanager.web.controller.exclude;

import com.bxm.adsmanager.integration.datapark.model.DataParkContens;
import com.bxm.adsmanager.model.constant.ReportConstant;
import com.bxm.adsmanager.service.datapark.DataparkPositionTestService;
import com.bxm.adsmanager.web.controller.base.ExcludeBaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

/**
 * @FileName package com.bxm.adsmanager.web.controller.adkeeper.AdTicketController.java
 * @CopyRright (c) 2017-bxm：杭州微财科技有限公司:
 * @Creator hcmony
 * @Created 2017-12-07 16:04:00
 * @Description 参数不受拦截器控制
 */
@RestController
@RequestMapping("/exclude")
public class ExcludeMediaPositionTestController extends ExcludeBaseController {
 
    @Autowired
    private DataparkPositionTestService                dataparkPositionTestService;
	  /**
     * 导出媒体测试报表
     * 
     * @author 拉拉
     * @date 2018/2/28 11:09
     * @param
     * @return
     */
    @RequestMapping(value = "/positionTestReportExport", method = RequestMethod.GET)
    public void positionTestReportExport(@RequestParam(name = DataParkContens.KEYWORDS, required = false) String keywords,
                                         @RequestParam(name = DataParkContens.SHOP_TYPE, required = false) String shoptype,
                                         @RequestParam(name = DataParkContens.AREA_TYPE, required = false) String areatype,
                                         @RequestParam(name = DataParkContens.SEARCH_TYPE, required = true) String searchtype,
                                         @RequestParam(name = DataParkContens.POSITIONID, required = true) String positionid,
                                         @RequestParam(name = DataParkContens.SORT_NAME, defaultValue = ReportConstant.OPEN_PV_VO) String sortName,
                                         @RequestParam(name = DataParkContens.SORT_TYPE, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType,
                                         HttpServletResponse response) {

        dataparkPositionTestService.positionTestReportExport(keywords, positionid, sortName, sortType, areatype,
                                                             searchtype, shoptype, response);

    }
}
