package com.bxm.adsmanager.web.controller.exclude;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.adsmedia.provider.ProviderFacadeIntegration;
import com.bxm.adsmanager.model.dao.position.PositionQualityFactor;
import com.bxm.adsmanager.service.position.PositionQualityFactorService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.DateUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.util.*;

/**
 * @author wangchao
 * @Title:ExcludePositionController.java
 * @Package:com.bxm.adsmanager.web.controller.exclude
 * @Description: 涉及广告位质量因子关于excel的操作
 * @date:2018年10月15日 下午6:01:11
 */

@RestController
@RequestMapping("/exclude")
public class ExcludePositionController {

    private static final Logger LOGGER = LoggerFactory.getLogger(ExcludePositionController.class);

    @Autowired
    private NewAppEntranceFacadeIntegration appEntranceFacadeIntegration;

    @Autowired
    private PositionQualityFactorService positionQualityFactorService;

    @LogBefore(keyName = "导入广告位质量因子", operType = "/exclude/importPositionQualityFactor")
    @RequestMapping(value = "/importPositionQualityFactor", method = RequestMethod.POST)
    public ResultModel<String> importPositionQualityFactor(@RequestParam("file") MultipartFile file,
                                                           @RequestParam(required = false, name = "token") String token, HttpServletRequest request) {
        List<PositionQualityFactor> list = null;
        ImportParams importParams = new ImportParams();
        try {
            list = ExcelImportUtil.importExcel(file.getInputStream(), PositionQualityFactor.class, importParams);
            if (!CollectionUtils.isEmpty(list)) {
                //获取广告位和导入时间,并且校验导入的广告位数据是否存在重复的
                List<PositionQualityFactor> newList = dealImportData(list);
                Boolean flag = checkPositionQualityFactor(newList);
                if (!flag) {
                    return ResultModelFactory.FAIL500("广告位代号存在重复数据");
                }
                if (CollectionUtils.isNotEmpty(newList)) {
                    positionQualityFactorService.addPositionQualityFactorBatch(newList);
                }
            }
        } catch (Exception e) {
            LOGGER.error("导入质量因子Excel表格出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("导入质量因子Excel表格出错");
        }
        return ResultModelFactory.SUCCESS();
    }

    //拼接广告位和导入时间
    @Deprecated
    private List<PositionQualityFactor> generateImportData(List<PositionQualityFactor> param) {
        if (!CollectionUtils.isEmpty(param)) {
            for (PositionQualityFactor record : param) {
                if (StringUtils.isNotBlank(record.getAppKey()) && StringUtils.isNotBlank(record.getBusiness())) {
                    record.setPositionId(record.getAppKey() + "-" + record.getBusiness().replace("ad-", ""));
                    //今天导入的质量因子是昨天的
                    record.setImportTime(DateUtil.dateTo8String(DateUtil.increaseDate(new Date(), -1)));
                }
            }
        }
        return param;
    }

    //处理excel中的广告位代号
    private List<PositionQualityFactor> dealImportData(List<PositionQualityFactor> param) {
        List<PositionQualityFactor> resultList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(param)) {
            //查询广告位代号
            Map<String, String> appEntranceCodeName = appEntranceFacadeIntegration.getAppEntranceCodeName();
            if (MapUtils.isEmpty(appEntranceCodeName)) {
                appEntranceCodeName = Maps.newHashMap();
            }
            String importTime = DateUtil.dateTo8String(DateUtil.increaseDate(new Date(), -1));
            for (PositionQualityFactor record : param) {
                //过滤质量因子为空的
                if (StringUtils.isBlank(record.getFactor()) || StringUtils.isBlank(record.getPositionCode())) {
                    continue;
                }
                if (StringUtils.isNotBlank(record.getPositionCode())) {
                    record.setPositionId(appEntranceCodeName.get(record.getPositionCode()));
                    if (StringUtils.isNotBlank(record.getPositionId())) {
                        record.setImportTime(importTime);
                        resultList.add(record);
                    }
                }
            }
        }
        return resultList;
    }

    //校验广告位是否存在重复
    private Boolean checkPositionQualityFactor(List<PositionQualityFactor> list) {
        List<String> positionIds = new ArrayList<>();
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(positionQualityFactor -> {
                if (StringUtils.isNotBlank(positionQualityFactor.getPositionId())) {
                    positionIds.add(positionQualityFactor.getPositionId());
                }
            });
            return positionIds.size() == new HashSet<Object>(positionIds).size();
        }
        return true;
    }

}
