package com.bxm.adsmanager.web.controller.exclude;
import com.bxm.adsmanager.model.dao.prize.TblAdPrize;
import com.bxm.adsmanager.service.prize.PrizeService;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.adsmanager.web.controller.base.ExcludeBaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/** 落地页
 * @author sunzhongshu
 * @fileName
 * @CopyRright (c) 2018-杭州微财科技有限公司
 * @created 2018/5/8 10:47
 */
@RestController
@RequestMapping("/exclude")
public class ExcludePrizeController extends ExcludeBaseController {

    @Autowired
    private PrizeService prizeService;

    /**
     * 奖品落地页数据不分页导出
     * @CopyRright  (c) 2018-微财科技有限公司
     * @author sunzhongshu
     * @created 2018/5/8 10:52
     * @modifier sunzhongshu
     */
    @RequestMapping(value = "/prize/export",method = RequestMethod.GET)
    public void prizeExport(HttpServletRequest request,
                            HttpServletResponse response,
                            @RequestParam(name = "dateTime",required = false) String dateTime,
                            @RequestParam(name = "keyWords",required = false) String keyWords){

        List<TblAdPrize> list= prizeService.prizeFind(dateTime,keyWords);
        ExcelUtil.exportExcel(list,null,null,TblAdPrize.class,"奖品落地页数据.xls",response);

    }

}
