package com.bxm.adsmanager.web.controller.exclude;

import com.bxm.adsmanager.ecxeption.ExcelException;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdTicketSearchDto;
import com.bxm.adsmanager.model.vo.AdTicketAllVo;
import com.bxm.adsmanager.model.vo.PaginationTemp;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.adsmanager.web.controller.base.ExcludeBaseController;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Collections;
import java.util.List;

/**
 * 文 件 名 :
 * CopyRright (c) 2008-xxxx:
 * 文件编号：
 * 创 建 人： hxpeng
 * 日 期： 2018/7/26 17:19
 * 修 改 人：
 * 日 期：
 * 描 述：
 * 版 本 号： v1
 */

@RestController
@RequestMapping("/exclude/ticket")
public class ExcludeTicketController extends ExcludeBaseController {

    @Autowired
    private AdTicketService adTicketService;


    /**
     * Description: 广告列表数据导出
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/7/26 17:22
     */
    @RequestMapping(value = "/list/export", method = RequestMethod.GET)
    public void export(HttpServletResponse response, AdTicketSearchDto searchDto, HttpServletRequest request) throws ExcelException {
        searchDto.setPageNum(1);
        searchDto.setPageSize(500);
        if(StringUtils.isBlank(searchDto.getPvStartTime()) || StringUtils.isBlank(searchDto.getPvEndTime())){
            throw new RuntimeException("查询时间不能为空");
        }
        try {
            User user = getUser(request,response);
            PaginationTemp<AdTicketAllVo> result = adTicketService.findAll(searchDto,user);
            List<AdTicketAllVo> exportList;
            if (null == result || CollectionUtils.isEmpty(result.getList())){
                exportList = Collections.emptyList();
            } else {
                exportList = result.getList();
            }
            ExcelUtil.exportExcel(exportList, null, null, AdTicketAllVo.class, "广告券列表数据导出.xls", response);
        }catch (Exception e){
            e.printStackTrace();
            throw new RuntimeException("查找所有广告券出错");
        }
    }

}
