package com.bxm.adsmanager.web.controller.exclude;

import com.bxm.adsmanager.model.dto.AdTicketSearchDto;
import com.bxm.adsmanager.model.vo.AdTicketAllVo;
import com.bxm.adsmanager.model.vo.AdTicketCostLogVo;
import com.bxm.adsmanager.model.vo.PaginationTemp;
import com.bxm.adsmanager.service.adkeeper.AdTicketCostService;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.adsmanager.web.controller.base.ExcludeBaseController;
import com.bxm.util.dto.ResultModel;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Collections;
import java.util.List;

/**
 * @author sunzs
 * created on 2018/9/13
 */
@RestController
@RequestMapping("/exclude/ticket/cost")
public class ExcludeTicketCostController {

    @Autowired
    private AdTicketCostService adTicketCostService;

    @RequestMapping(value = "/findAll",method = RequestMethod.GET)
    public void findAll(AdTicketSearchDto adTicketSearchDto, @RequestParam(value = "costIds",required = false) String costIds , HttpServletRequest request, HttpServletResponse response){

        try {
            adTicketSearchDto.setPageSize(999999);
            PaginationTemp result=  adTicketCostService.findAll(adTicketSearchDto,costIds);
            List<AdTicketCostLogVo> exportList;
            if (null == result || CollectionUtils.isEmpty(result.getList())){
                exportList = Collections.emptyList();
            } else {
                exportList = result.getList();
            }
            ExcelUtil.exportExcel(exportList, null, null, AdTicketCostLogVo.class, "券耗记录导出.xls", response);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("导出券耗记录出错");
        }
    }



}
