package com.bxm.adsmanager.web.controller.explore;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.model.dao.explore.TicketExplore;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.TicketArpuDTO;
import com.bxm.adsmanager.model.dto.explore.TicketExploreConfigDto;
import com.bxm.adsmanager.model.dto.explore.TicketExploreDto;
import com.bxm.adsmanager.model.vo.AdTicketArpuVo;
import com.bxm.adsmanager.model.vo.explore.TicketExploreVo;
import com.bxm.adsmanager.service.explore.TicketExploreService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * @author 拉拉
 * @version v1.0.0
 * @fileName com.bxm.adsmanager.web.controller.explore.TicketExplore.java
 * @created 2022-11-10 17:21:00
 * @modifier 拉拉
 * @updated 2022-11-10 17:21:00
 */
@Slf4j
@RestController
@RequestMapping("/explore")
public class TicketExploreController extends BaseController {

    @Autowired
    TicketExploreService ticketExploreService;

    @RequestMapping(value = "/add", produces = "application/json")
    public ResultModel add(HttpServletRequest request, HttpServletResponse response,
                           TicketExploreDto ticketExploreDto) {
        try {
            // 获取后台用户名
            User user = getUser(request, response);
            ticketExploreService.add(ticketExploreDto, user.getUsername());
            return ResultModelFactory.SUCCESS();
        } catch (Exception e) {
            log.error("新增加速探索出错", e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }


    @RequestMapping(value = "/findById", method = RequestMethod.GET)
    public ResultModel<TicketExploreVo> findById(Long ticketId) {
        ResultModel<TicketExploreVo> rs = new ResultModel<>();
        try {
            TicketExploreVo ticketExploreVo = ticketExploreService.findById(ticketId);
            rs.setReturnValue(ticketExploreVo);
        } catch (Exception e) {
            log.error("查找广告券appu出错" + e.getMessage(), e);
            rs.setErrorDesc(e.getMessage());
        }
        return rs;
    }


    @RequestMapping(value = "/update", produces = "application/json")
    public ResultModel update(HttpServletRequest request, HttpServletResponse response,
                              TicketExploreDto ticketExploreDto) {
        try {
            // 获取后台用户名
            User user = getUser(request, response);
            ticketExploreService.update(ticketExploreDto, user.getUsername());
            return ResultModelFactory.SUCCESS();
        } catch (Exception e) {
            log.error("修改加速探索出错", e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }

    @RequestMapping(value = "/findOrUpdateConsume", method = RequestMethod.GET)
    public ResultModel<String> findConsume(Long id, Integer type) {
        ResultModel<String> rs = new ResultModel<>();
        try {
            String value = ticketExploreService.findConsume(id, type);
            rs.setReturnValue(value);
        } catch (Exception e) {
            log.error("生成消耗出错" + e.getMessage(), e);
            rs.setErrorDesc(e.getMessage());
        }
        return rs;
    }


    @RequestMapping(value = "/test", method = RequestMethod.GET)
    public ResultModel<String> test(Long id) {
        ResultModel<String> rs = new ResultModel<>();
        try {
            String value = ticketExploreService.push1(id);
            rs.setReturnValue(value);
        } catch (Exception e) {
            log.error("生成消耗出错" + e.getMessage(), e);
            rs.setErrorDesc(e.getMessage());
        }
        return rs;
    }
}
