package com.bxm.adsmanager.web.controller.facade;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdAssetsTemplateMapperExt;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.facade.service.AdAssetsTemplateFacadeService;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplate;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplateExample;
import com.bxm.adsmanager.model.dto.AdAssetsTemplateDTO;
import com.bxm.adsmanager.service.adkeeper.AdAssetsTemplateService;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;

/**
 * 素材模板
 *
 * @author zhengwangeng
 * @since 2022-02-09
 */
@RestController
public class AdAssetsTemplateFacadeServiceImpl implements AdAssetsTemplateFacadeService {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdAssetsTemplateFacadeServiceImpl.class);

    @Autowired
    private AdAssetsTemplateMapperExt adAssetsTemplateMapperExt;
    @Autowired
    private AdAssetsTemplateService adAssetsTemplateService;

    @Override
    public ResultModel<Long> findIdByName(String name) {
        //素材模板名称要求唯一
        AdAssetsTemplateExample example = new AdAssetsTemplateExample();
        example.createCriteria().andNameEqualTo(name);
        List<AdAssetsTemplate> adAssetsTemplates = adAssetsTemplateMapperExt.selectByExample(example);
        if (CollectionUtils.isNotEmpty(adAssetsTemplates)) {
            return ResultModelFactory.SUCCESS(adAssetsTemplates.get(0).getId());
        }
        return ResultModelFactory.SUCCESS(null);
    }

    @Override
    public ResultModel<Long> add(@RequestBody String json) {
        AdAssetsTemplateDTO dto = JsonHelper.convert(json, AdAssetsTemplateDTO.class);
        dto.setCreateUser("facade");
        return ResultModelFactory.SUCCESS(adAssetsTemplateService.add(dto));
    }

}
