package com.bxm.adsmanager.web.controller.facade;
import com.bxm.adsmanager.model.vo.tbltag.TblAdTagVo;
import com.bxm.adsmanager.service.tbltag.TblAdTagService;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
* @Title:TblAdTagController.java
* @Package:com.bxm.adsmanager.web.controller.facade
* @Description: 提供给广告主后台的标签查询服务
 */
@RestController
@RequestMapping("/adtag")
public class AdTagController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdTagController.class);

    @Autowired
    private TblAdTagService tblAdTagService;

    /**
     * 根据类型标签列表（分页）
     * 
     * @param parentId
     * @param type（1属性 2 分类 3广告主 4盘古素材标签）
     * @return
     */
    @RequestMapping(value = "newTreeAll", method = RequestMethod.GET)
    public ResultModel<PageInfo<TblAdTagVo>> findNewTreeAll(@RequestParam(value = "parentId", defaultValue = "0") Integer parentId,
                                                        @RequestParam(value = "type",defaultValue = "1") Integer type,
                                                        @RequestParam(value = "name", defaultValue = "") String name,
                                                        @RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                                                        @RequestParam(value = "pageSize", defaultValue = "20") Integer pageSize) {

        ResultModel<PageInfo<TblAdTagVo>> resultModel = new ResultModel<>();
        try {
            PageInfo<TblAdTagVo> pag = tblAdTagService.findNewTreeAll(pageNum, pageSize, type, name, parentId);
            resultModel.setReturnValue(pag);
        } catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查询标签列表出错");
            LOGGER.error(e.getMessage(), e);
            return resultModel;
        }
        return resultModel;
    }
    
    /**
     * 查询所有 标签
     * 
     * @param pageNum
     * @param pageSize
     * @return
     */
    @RequestMapping(value = "newAll",method = RequestMethod.GET)
    public ResultModel<PageInfo<TblAdTagVo>> findNewAll(@RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                                                           @RequestParam(value = "pageSize", defaultValue = "20") Integer pageSize,
                                                           @RequestParam(value = "name", defaultValue = "") String name,
                                                           @RequestParam(value = "type",defaultValue = "1") Integer type) {
        ResultModel<PageInfo<TblAdTagVo>> resultModel = new ResultModel<>();
        try {
            PageInfo<TblAdTagVo> list = tblAdTagService.findNewAll(pageNum, pageSize, name,type);
            resultModel.setSuccessed(true);
            resultModel.setReturnValue(list);
        } catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查询标签列表出错");
            LOGGER.error(e.getMessage(), e);
            return resultModel;
        }
        return resultModel;
    }


}
