package com.bxm.adsmanager.web.controller.facade;

import com.bxm.adsmanager.model.dao.diysite.SiteInstanceDao;
import com.bxm.adsmanager.model.dao.diysite.SiteInstanceDto;
import com.bxm.adsmanager.model.dao.diysite.SiteTemplateDao;
import com.bxm.adsmanager.service.diysite.SiteInstanceService;
import com.bxm.adsmanager.service.diysite.SiteTemplateService;
import com.bxm.util.dto.ErrorCode;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;


@RestController
@RequestMapping("/advertiser/diysite")
public class AdvertiserDIYSiteController {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertiserDIYSiteController.class);

    @Autowired
    private SiteTemplateService siteTemplateService;

    @Autowired
    private SiteInstanceService siteInstanceService;

    @RequestMapping("/getTemplates")
    public ResultModel getTemplates(@RequestBody  SiteInstanceDto dto){
        ResultModel rs = new ResultModel();
        if(null == dto || null == dto.getAdvertiserId() || dto.getAdvertiserId() <= 0){
            rs.setSuccessed(Boolean.FALSE);
            rs.setErrorCode(ErrorCode.ILLEGAL_PARAMS.getErrorCode());
            rs.setErrorDesc("id不可以为空");
            return rs;
        }
        try {
            Map<String,List<SiteTemplateDao>> all = siteTemplateService.findAll(dto);
            rs.setReturnValue(all);
        }catch (Exception e){
            rs.setSuccessed(Boolean.FALSE);
            LOGGER.error("getTemplates Error",e);
        }
        return rs;

    }

    @RequestMapping("/findAll")
    public ResultModel findAll(@RequestBody  SiteInstanceDto dto){
        ResultModel rs = new ResultModel();
        try {
            PageInfo<SiteInstanceDao> all = siteInstanceService.findAll(dto);
            rs.setReturnValue(all);
        }catch (Exception e){
            rs.setSuccessed(Boolean.FALSE);
            LOGGER.error("findAll Error",e);
        }
        return rs;
    }

    @LogBefore(operType = "/advertiser/diysite/add", keyName = "新建自建站")
    @RequestMapping(value = "/add", produces = "application/json")
    public ResultModel add(@RequestBody  SiteInstanceDto dto){
        ResultModel rs = new ResultModel();
        try {
            rs.setReturnValue(siteInstanceService.saveOrUpdate(dto,null));
        }catch (Exception e){
            rs.setSuccessed(Boolean.FALSE);
            LOGGER.error("add Error",e);
        }
        return rs;
    }

    @LogBefore(operType = "/advertiser/diysite/update", keyName = "更新自建站")
    @RequestMapping(value = "/update", produces = "application/json")
    public ResultModel update(@RequestBody  SiteInstanceDto dto){
        ResultModel rs = new ResultModel();
        try {
            rs.setReturnValue(siteInstanceService.saveOrUpdate(dto,null));
        }catch (Exception e){
            rs.setSuccessed(Boolean.FALSE);
            LOGGER.error("update Error",e);
        }
        return rs;
    }

    @RequestMapping("/get")
    public ResultModel get(@RequestBody  SiteInstanceDto dto){
        ResultModel rs = new ResultModel();
        if(null == dto || null == dto.getId() || dto.getId() <= 0){
            rs.setSuccessed(Boolean.FALSE);
            rs.setErrorCode(ErrorCode.ILLEGAL_PARAMS.getErrorCode());
            rs.setErrorDesc("id不可以为空");
            return rs;
        }
        try {
            rs.setReturnValue(siteInstanceService.getById(dto.getId()));
        }catch (Exception e){
            rs.setSuccessed(Boolean.FALSE);
            LOGGER.error("update Error",e);
        }
        return rs;
    }

}
