package com.bxm.adsmanager.web.controller.facade;

import com.bxm.adsmanager.model.dao.audit.QualificationConfig;
import com.bxm.adsmanager.model.vo.audit.QualificationConfigVo;
import com.bxm.adsmanager.service.audit.QualificationService;
import com.bxm.util.dto.ResultModel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author tangx
 * @date 2020/6/29 16:04
 */
@RestController
@RequestMapping("/advertiser")
@Slf4j
public class AdvertiserQualificationController {

    @Autowired
    private QualificationService qualificationService;

    @RequestMapping(value = "/qualification/getList", produces = "application/json")
    public ResultModel<List<QualificationConfigVo>> getList(
            @RequestParam(value = "keywords", required = false) String keywords,
            @RequestParam(value = "status", required = false) String status,
            @RequestParam(value = "grade", required = false) String grade,
            @RequestParam(value = "parentId",required = false) String parentId) {
        ResultModel<List<QualificationConfigVo>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(qualificationService.getList(grade,keywords,
                    status,parentId));
            resultModel.setSuccessed(true);

        } catch (Exception e) {
            log.error("查找资质菜单列表出错", e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查找资质菜单列表出错");
        }
        return resultModel;
    }

    @RequestMapping(value = "/qualification/getAllList", produces = "application/json")
    public ResultModel<List<QualificationConfig>> getAllList() {
        ResultModel<List<QualificationConfig>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(qualificationService.getAllList());
            resultModel.setSuccessed(true);

        } catch (Exception e) {
            log.error("查找资质列表出错", e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查找资质列表出错");
        }
        return resultModel;
    }

}
