package com.bxm.adsmanager.web.controller.facade;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.ro.QualifyContentRo;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.model.dao.advertiser.TblAdQualify;
import com.bxm.adsmanager.model.dto.TblAdQualifyDto;
import com.bxm.adsmanager.service.advertiser.AdvertiserQualifyService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;

/**
* @Title:AdvertiserQualifyController.java
* @Package:com.bxm.adsmanager.web.controller.facade
* @Description: 广告主资质操作类
 */
@RestController
@RequestMapping("/advertiser")
public class AdvertiserQualifyController {
    
    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertiserQualifyController.class);

    /**
     * 广告主资质操作接口
     */
    @Autowired
    private AdvertiserQualifyService advertiserQualifyService;
    
    /**
    * @Title: addQualify  
    * @Description: 添加广告主的资质信息
    * @return ResultModel<Boolean> 
     */
    @RequestMapping(value = "/qualify",method = RequestMethod.POST)
    public ResultModel<Boolean> addQualify(@RequestBody String json){

        ResultModel<Boolean> resultModel = new ResultModel<Boolean>();
        if (StringUtils.isBlank(json)){
            return ResultModelFactory.FAIL500("资质信息不能为空");
        }

        try {
            List<TblAdQualify> list = JSON.parseArray(json,TblAdQualify.class);
            advertiserQualifyService.addAdvertiserQualifyBatch(list);
        } catch (BusinessException e) {
            LOGGER.error(e.getMessage(), e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }  catch (Exception e) {
            LOGGER.error("添加资质信息出错"+ e.getMessage(), e);
            resultModel.setReturnValue(false);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("添加资质信息出错");
            return resultModel;
        }
        resultModel.setReturnValue(true);
        return resultModel;
    }

    public static void main(String[] args) {
        QualifyContentRo qualifyContentRo1 = new QualifyContentRo();
        QualifyContentRo qualifyContentRo2 = new QualifyContentRo();
        QualifyContentRo qualifyContentRo3 = new QualifyContentRo();
        QualifyContentRo qualifyContentRo4 = new QualifyContentRo();

        List<QualifyContentRo> result = new ArrayList<>();
        qualifyContentRo1.setQualifyName("test1");
        qualifyContentRo1.setExpireTime("2022-02-18");
        qualifyContentRo1.setImages("www.baidu.com,www.baidu.com");
        qualifyContentRo1.setLongTime(false);

        qualifyContentRo2.setQualifyName("test1");
        qualifyContentRo2.setExpireTime("2022-02-18");
        qualifyContentRo2.setImages("www.baidu.com,www.baidu.com");
        qualifyContentRo2.setLongTime(false);

        qualifyContentRo3.setQualifyName("test1");
        qualifyContentRo3.setExpireTime("2022-02-18");
        qualifyContentRo3.setImages("www.baidu.com,www.baidu.com");
        qualifyContentRo3.setLongTime(false);

        qualifyContentRo4.setQualifyName("test1");
        qualifyContentRo4.setExpireTime("2022-02-18");
        qualifyContentRo4.setImages("www.baidu.com,www.baidu.com");
        qualifyContentRo4.setLongTime(false);

        result.add(qualifyContentRo1);
        result.add(qualifyContentRo2);
        result.add(qualifyContentRo3);
        result.add(qualifyContentRo4);

        System.out.println(JSON.toJSONString(result));

        String qualifyContent = JSON.toJSONString(result);


        TblAdQualify tblAdQualify = new TblAdQualify();
        tblAdQualify.setAdvertiserId(4902L);
        tblAdQualify.setQualifyName(404);
        tblAdQualify.setContent("sfsdf");
        tblAdQualify.setQualifyContent(qualifyContent);

        List<TblAdQualify> tblAdQualifyList = new ArrayList<>();

        tblAdQualifyList.add(tblAdQualify);

        System.out.println(JSON.toJSONString(tblAdQualifyList));

    }
    /**
    * @Title: getQualifyById  
    * @Description: 根据ID查询广告主资质信息
    * @param  id
    * @return ResultModel<TblAdQualify> 
     */
     @RequestMapping(value = "/qualifyById",method = RequestMethod.GET)
     public ResultModel<TblAdQualify> getQualifyById(@RequestParam(name = "id") Integer id){
         ResultModel<TblAdQualify> resultModel = new ResultModel<TblAdQualify>();
         try {
            resultModel.setReturnValue(advertiserQualifyService.getAdQualifyById(id));
        } catch (Exception e) {
            LOGGER.error("查询资质信息出错"+ e.getMessage(), e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查询资质信息出错");
            return resultModel;
        }
         return resultModel;
     }
     
     /**
      * @Title: updateQualifyById  
      * @Description: 根据ID更新广告主资质信息
      * @param record TblAdQualify
      * @return ResultModel<TblAdQualify> 
       */
       @RequestMapping(value = "/updateQualify",method = RequestMethod.POST)
       public ResultModel<Boolean> updateQualifyById(@RequestBody TblAdQualify record){
           ResultModel<Boolean> resultModel = new ResultModel<Boolean>();
           if (record == null || record.getId() == null){
               return ResultModelFactory.FAIL500("id不能为空");
           }
           if (org.apache.commons.lang3.StringUtils.isBlank(record.getContent())) {
               return ResultModelFactory.FAIL400("请填写投放产品名称");
           }
           try {
               advertiserQualifyService.updateAdQualifyById(record);
           } catch (BusinessException e) {
               LOGGER.error(e.getMessage(), e);
               return ResultModelFactory.FAIL500(e.getMessage());
           } catch (Exception e) {
               LOGGER.error("更新资质信息出错" + e.getMessage(), e);
               resultModel.setSuccessed(false);
               resultModel.setErrorDesc("更新资质信息出错");
               return resultModel;
           }
           resultModel.setReturnValue(true);
           return resultModel;
       }

       /**
        * @Title: getQualifyList
        * @Description: 查询广告主资质信息列表
        * @return ResultModel<TblAdQualify>
         */
         @RequestMapping(value = "/getQualifyList",method = RequestMethod.GET)
         public ResultModel<PageInfo<TblAdQualify>> getQualifyList(
                 @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
             @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize,
             @RequestParam(name = "auditStatus",required = false) Integer auditStatus,
             @RequestParam(value = "advertiserIds", required = false) List<Long> advertiserIds,
             @RequestParam(value = "advertiserId", required = false) Long advertiserId){
             ResultModel<PageInfo<TblAdQualify>> resultModel = new ResultModel<PageInfo<TblAdQualify>>();
             TblAdQualifyDto param = new TblAdQualifyDto();
             param.setPageNum(pageNum);
             param.setPageSize(pageSize);
             param.setAuditStatus(auditStatus);
             param.setAdvertiserList(advertiserIds);
             param.setAdvertiserId(advertiserId);
             try {
                resultModel.setReturnValue(advertiserQualifyService.getAdQualifyList(param));
            } catch (Exception e) {
                LOGGER.error("查询资质列表信息出错"+ e.getMessage(), e);
                resultModel.setSuccessed(false);
                resultModel.setErrorDesc("查询资质列表信息出错");
                return resultModel;
            }
             return resultModel;
         }
    /**
     * @Title: getQualifyList
     * @Description: 查询广告主资质信息列表
     * @return ResultModel<TblAdQualify>
     */
    @RequestMapping(value = "/getQualifyListByRequestBody",method = RequestMethod.POST)
    public ResultModel<PageInfo<TblAdQualify>> getQualifyListByRequestBody(
            @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
            @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize,
            @RequestParam(name = "auditStatus",required = false) Integer auditStatus,
            @RequestBody  List<Long> advertiserIds,
            @RequestParam(name = "content", required = false) String content){
        ResultModel<PageInfo<TblAdQualify>> resultModel = new ResultModel<PageInfo<TblAdQualify>>();
        TblAdQualifyDto param = new TblAdQualifyDto();
        param.setPageNum(pageNum);
        param.setPageSize(pageSize);
        param.setAuditStatus(auditStatus);
        param.setAdvertiserList(advertiserIds);
        param.setContent(content);
        try {
            resultModel.setReturnValue(advertiserQualifyService.getAdQualifyList(param));
        } catch (Exception e) {
            LOGGER.error("查询资质列表信息出错"+ e.getMessage(), e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查询资质列表信息出错");
            return resultModel;
        }
        return resultModel;
    }
}
