/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.adsmanager.web.controller.facade;


import com.bxm.adsmanager.integration.adsprod.service.ProdAdvertiserIntegration;
import com.bxm.adsmanager.integration.adsprod.service.ProdPullerIntegration;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.commons.currency.Money;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * <h3>供广告调用</h3>
 * <p>//todo 这里后面可能做参数验证，权限拦截过滤 以及是否要移到 facade  项目中</p>
 * @author hcmony
 * @since V1.0.0, 2018/02/28 19:11
 */
@RestController
@RequestMapping("/advertiser")
public class AdvertiserTicketController extends BaseController{

	private static final Logger LOGGER = LoggerFactory.getLogger(AdvertiserTicketController.class);

	@Autowired
	private AdTicketService adTicketService;
	@Autowired
	private ProdAdvertiserIntegration prodAdvertiserIntegration;
	@Autowired
	private ProdPusherIntegration prodPusherIntegration;
	
    @Autowired
    private ProdPullerIntegration             prodPuller;

	/**
	 * @description advertiser更新广告券状态
	 * @author hcmony
	 * @time 2018/2/28
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param request
	 * @param response
	 * @param id
	 * @param status
	 * @return com.bxm.util.dto.ResultModel
	 */

	@LogBefore(user = "advertiser",operType="/advertiser/updateAdTicket",keyName="广告")
	@RequestMapping(value = "/updateAdTicket", method = RequestMethod.POST)
	public ResultModel update(HttpServletRequest request, HttpServletResponse response,
							  @RequestParam(required = true, name = "id" ) Long id,
							  @RequestParam(required = true,name = "status") Short status
								) {
		//状态。1 正常、2 暂停、3 停止、99 已删除
		//暂停原因。1- 超出预算、2- 余额不足;3-未到投放日期;4-投放结束
		response.setHeader("Access-Control-Allow-Origin", "*");

		ResultModel rs = new ResultModel();
		try {
			AdTicket adTicket = new AdTicket();
			adTicket.setId(id);
			adTicket.setStatus(status);
			adTicket.setModifyUser("广告主更新");
			LOGGER.info("advertiser请求更新广告券状态:id="+id+",status="+status);
			Integer result = adTicketService.advertiserUpdateStatus(adTicket);
			//日志记录
			//addLogs(user, JSON.toJSONString(AdTicket.AdTicketStatus.getName(status)+"广告券"),id+"");
			rs.setReturnValue(result);
		}catch (Exception e){
			LOGGER.error("advertiser更新广告券状态出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL();
		}
		return  rs;
	}

	/**
	 * @description advertiser更新广告券日预算
	 * @author hcmony
	 * @time 2018/2/28
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param request
	 * @param response
	 * @param id
	 * @param dailyBudget
	 * @return com.bxm.util.dto.ResultModel
	 */

	@LogBefore(user = "advertiser",operType="/advertiser/updateDailyBudget",keyName="广告")
	@RequestMapping(value = "/updateDailyBudget", method = RequestMethod.POST)
	public ResultModel update(HttpServletRequest request, HttpServletResponse response,
							  @RequestParam(required = true, name = "id" ) Long id,
							  @RequestParam(required = true,name = "dailyBudget") Double dailyBudget
							) {
		//状态。1 正常、2 暂停、3 停止、99 已删除
		//暂停原因。1- 超出预算、2- 余额不足;3-未到投放日期;4-投放结束
		response.setHeader("Access-Control-Allow-Origin", "*");

		ResultModel rs = new ResultModel();
		try {
			LOGGER.info("advertiser请求更新广告券日预算:id="+id+",dailyBudget="+dailyBudget);
			Integer result = adTicketService.updateDailyBudget(id,dailyBudget);
			//日志记录
			//addLogs(user, JSON.toJSONString("更新广告券日预算,金额："+dailyBudget),id+"");
			rs.setReturnValue(result);
		}catch (Exception e){
			LOGGER.error("advertiser请求更新广告券日预算"+e.getMessage(), e);
			return ResultModelFactory.FAIL();
		}
		return  rs;
	}
	
	/**
     * @description advertiser获取广告主余额
     * @author 拉拉
     * @time 2018/7/02
     * @CopyRight 杭州微财网络科技有限公司
     * @param request
     * @param id
     * @param dailyBudget
     * @return com.bxm.util.dto.ResultModel
     */

    @LogBefore(user = "advertiser",operType="/advertiser/getAdvertiserBalance",keyName="广告")
    @RequestMapping(value = "/getAdvertiserBalance", method = RequestMethod.GET)
    public ResultModel getAdvertiserBalance(@RequestParam(required = true, name = "id" ) Long id) { 
        ResultModel rs = new ResultModel();
        try { 
            Money money = Money.ofLi(prodPuller.getAdvertiserBalance(id));
            rs.setReturnValue(money.getYuan());
        }catch (Exception e){
            LOGGER.error("advertiser获取广告主余额失败："+e.getMessage(), e);
            return ResultModelFactory.FAIL();
        }
        return  rs;
    }

	@LogBefore(user = "advertiser",operType="/advertiser/reUpdateAdTicket",keyName="广告")
	@RequestMapping(value = "/reUpdateAdTicket", method = RequestMethod.POST)
	public ResultModel reUpdate(HttpServletRequest request, HttpServletResponse response,
							  @RequestParam(required = true, name = "id" ) Long id,
							  @RequestParam(required = true,name = "status") Short status
	) {
		//状态。1 正常、2 暂停、3 停止、99 已删除
		//暂停原因。1- 超出预算、2- 余额不足;3-未到投放日期;4-投放结束
		response.setHeader("Access-Control-Allow-Origin", "*");

		ResultModel rs = new ResultModel();
		try {
			AdTicket adTicket = new AdTicket();
			adTicket.setId(id);
			adTicket.setStatus(status);
			adTicket.setModifyUser("广告主更新");
			LOGGER.info("advertiser请求重新提交审核:id="+id+",status="+status);
			Integer result = adTicketService.advertiserReUpdateStatus(adTicket);
			rs.setReturnValue(result);
		}catch (Exception e){
			LOGGER.error("advertiser更新广告券状态出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL();
		}
		return  rs;
	}

	/**
	 *
	 * 功能描述: 找到广告及子账号实时余额
	 * @fileName:
	 * @param:
	 * @return:
	 * @auther: sunzs
	 * @date: 2018/10/29 16:29
	 */
	@RequestMapping(value = "/findBalanceByIds", method = RequestMethod.POST)
	public ResultModel findBalanceByIds(@RequestParam(value = "advertiserIds") List<Integer> advertiserIds){
		ResultModel rs = new ResultModel();
		try {

			Map<Integer,Long> map = prodPuller.findBalanceByIds(advertiserIds);
			rs.setReturnValue(map);
		}catch (Exception e){
			LOGGER.error("advertiser获取广告主及子账号余额失败："+e.getMessage(), e);
			return ResultModelFactory.FAIL();
		}
		return  rs;

	}

	/**
	 *
	 * 功能描述: 找到广告及子账号实时余额
	 * @fileName:
	 * @param:
	 * @return:
	 * @auther: sunzs
	 * @date: 2018/10/29 16:29
	 */
	@RequestMapping(value = "/findBalanceByIdsByPost", method = RequestMethod.POST)
	public ResultModel findBalanceByIdsByPost(@RequestBody List<Integer> advertiserIds){
		ResultModel rs = new ResultModel();
		try {

			Map<Integer,Long> map = prodPuller.findBalanceByIds(advertiserIds);
			rs.setReturnValue(map);
		}catch (Exception e){
			LOGGER.error("advertiser获取广告主及子账号余额失败："+e.getMessage(), e);
			return ResultModelFactory.FAIL();
		}
		return  rs;

	}

}
