package com.bxm.adsmanager.web.controller.facade;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.model.constant.RedisKeys;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssets;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketGetuiTagRef;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketOcpcConf;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketUrlTest;
import com.bxm.adsmanager.model.dto.AdTicketDto;
import com.bxm.adsmanager.model.vo.AdFlowPackageNewVo;
import com.bxm.adsmanager.model.vo.AdTicketVo;
import com.bxm.adsmanager.service.adflowpackage.AdTicketFlowNewService;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsService;
import com.bxm.adsmanager.service.adkeeper.AdTicketOcpcService;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.service.adkeeper.TblAdTicketModifyService;
import com.bxm.adsmanager.service.role.RoleService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.commons.currency.Money;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import com.bxm.warcar.aspect.before.LogBefore;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.utils.JsonHelper;

/**
* @Title:AdvertiserTicketNewController.java
* @Package:com.bxm.adsmanager.web.controller.facade
* @Description: 广告主后台操作广告
* @date:2018年7月2日 下午6:50:19
 */
@RestController
@RequestMapping("/advertiser")
public class AdvertiserTicketNewController extends BaseController{

	private static final Logger LOGGER = LoggerFactory.getLogger(AdvertiserTicketNewController.class);
    
	/**
	 * 广告接口
	 */
	@Autowired
	private AdTicketService adTicketService;
	
	/**
	 * 素材接口
	 */
	@Autowired
    private AdTicketAssetsService adTicketAssetsService;
	
	@Autowired
	private AdTicketFlowNewService adTicketFlowNewService;

    @Autowired
    private TblAdTicketModifyService tblAdTicketModifyService;
    
    @Autowired
    private AdTicketOcpcService adTicketOcpcService;

    @Autowired
    private AdShopIntegration adShopIntegration;

    @Autowired
    private  RoleService roleService;

    @Autowired
    private JedisUpdater jedisUpdater;
     
	@LogBefore(user = "advertiser", operType="/addAdAssets",keyName="广告")
    @RequestMapping(value = "/addAdAssets", method = RequestMethod.POST)
    public ResultModel<Long> addAssets(@RequestBody AdAssets adAssets)  {
        ResultModel<Long> rs = new ResultModel<Long>();
        if(adAssets ==null){
            return ResultModelFactory.FAIL500("参数不可以为空");
        }
        try {
            rs = checkParam(rs,adAssets);
            if(!rs.isSuccessed()){
                return rs;
            }
            Long id = adTicketAssetsService.add(adAssets);
            rs.setReturnValue(id);
        }catch (Exception e){
            LOGGER.error("添加广告素材出错"+e.getMessage(), e);
            return ResultModelFactory.FAIL500("添加广告素材出错");
        }
        return rs;
    }
	
	@LogBefore(user = "advertiser",operType="/updateAdAssets",keyName="广告")
    @RequestMapping(value = "/updateAdAssets", method = RequestMethod.POST)
    public ResultModel<String> updateAssets(@RequestBody AdAssets adAssets) {
        ResultModel<String> rs = new ResultModel<>();
        if(adAssets == null|| adAssets.getId()==null){
            return ResultModelFactory.FAIL500("id不能为空");
        }
        String log ="";
        try {
            rs = checkParam(rs,adAssets);
            if(!rs.isSuccessed()){
                return rs;
            }
            //更新素材的时候，停止素材的推送
            log= adTicketAssetsService.updateAndAudit(adAssets,null);
        }catch (Exception e){
            LOGGER.error("更新广告素材出错"+e.getMessage(), e);
            return ResultModelFactory.FAIL500("更新广告素材出错");
        }
            rs.setReturnValue(log);
        return  rs;
    }
	
	/**
	* @Title: queryAdvertiserByParam  
	* @Description: 根据素材ID或者广告券ID查找广告券对应的广告主,提供给cpc广告主的权限校验使用
	* @return ResultModel<Long> 
	 */
	@RequestMapping(value = "/queryAdvertiserByParam", method = RequestMethod.GET)
    public ResultModel<Long> queryAdvertiserByParam (HttpServletRequest request,@RequestParam(required = false, name = "adAssetId") Long adAssetId,
            @RequestParam(required = false, name = "ticketId") Long ticketId) {
        ResultModel<Long> rs = new ResultModel<Long>();
        if(adAssetId == null && ticketId ==null){
            return ResultModelFactory.FAIL500("入参不能同时为空");
        }
        Long result = null;
        try {
            result = adTicketAssetsService.queryAdvertiserByParam(adAssetId,ticketId);
        }catch (Exception e){
            LOGGER.error("查找广告券异常"+e.getMessage(), e);
            rs.setErrorDesc("查找广告券异常");
            rs.setSuccessed(false);
            rs.setReturnValue(result);
            return rs;
        }
        rs.setReturnValue(result);
        return  rs;
    }
	
	/**
	* @Title: deleteAssets  
	* @Description: 删除广告券和素材的关联表，素材表不会动 
	* @return ResultModel<Boolean> 
	 */
	@LogBefore(user = "advertiser",operType="/delAdAssets",keyName="广告")
    @RequestMapping(value = "/delAdAssets", method = RequestMethod.DELETE)
    public ResultModel<Boolean>deleteAssets(HttpServletRequest request, HttpServletResponse response,
                                     @RequestParam(required = true, name = "id") String id) {
        ResultModel<Boolean> rs = new ResultModel<Boolean>();
        if(StringUtils.isBlank(id)){
            return ResultModelFactory.FAIL500("id不能为空");
        }
        try {
            adTicketAssetsService.deleteAndAudit(id);
        }catch (Exception e){
            LOGGER.error("删除广告券素材出错"+e.getMessage(), e);
            return ResultModelFactory.FAIL500("删除广告券素材出错");
        }
        return  rs;
    }
	
	@RequestMapping(value = "/findAllAssets", method = RequestMethod.GET)
    public ResultModel<List<AdAssets>> findAllAssets(HttpServletRequest request,
            @RequestParam(required = true, name = "ids") String ids) {
        ResultModel<List<AdAssets>> rs = new ResultModel<List<AdAssets>>();
        List<AdAssets> list = null;
        try {
            list = adTicketAssetsService.findAll(ids);
            rs.setReturnValue(list);
        }catch (Exception e){
            LOGGER.error("根据素材ids查找所有广告素材出错"+e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("根据素材ids查找所有广告素材出错");
            rs.setReturnValue(null);
            return rs;
        }
        return  rs;
    }
	
	@RequestMapping(value = "/findAllAssetsByTicketId", method = RequestMethod.GET)
    public ResultModel<List<AdAssets>>findAllAssetsByTicketId(@RequestParam(required = true, name = "ticketId")Long ticketId) {
        ResultModel<List<AdAssets>> rs = new ResultModel<List<AdAssets>>();
        List<AdAssets> list = null;
        try {
            list = adTicketAssetsService.findAllAssetsById(ticketId);
            rs.setReturnValue(list);
        }catch (Exception e){
            LOGGER.error("根据广告券id查找广告素材出错"+e.getMessage(), e);
            rs.setReturnValue(null);
            rs.setSuccessed(false);
            rs.setErrorDesc("根据广告券id查找广告素材出错");
            return rs;
        }
        return  rs;
    }

	/**
     * @description 素材参数校验
     * @author hcmony
     * @time 2017/12/29
     * @CopyRight 杭州微财网络科技有限公司
     * @param rs
     * @param adAssets
     * @return com.bxm.util.dto.ResultModel
     */
    public <T> ResultModel checkParam(ResultModel<T> rs ,AdAssets adAssets){

        if(AdAssets.VARS_NO==adAssets.getVars()&& StringUtil.isBlank(adAssets.getName())){
            return ResultModelFactory.FAIL400("不显示省市的时候name不能为空");
        }

        if(AdAssets.VARS_NO!=adAssets.getVars()&& StringUtil.isBlank(adAssets.getContent())){
            return ResultModelFactory.FAIL400("显示省市的时候素材内容不能为空");
        }

        //参数校验
        if (BeanValidator.validateGroup(adAssets, AdAssets.Add.class) != null) {
            return ResultModelFactory.FAIL400(BeanValidator.validateGroup(adAssets, AdAssets.Add.class).getMessage());
        }
        return  rs;
    }
    
    @LogBefore(user = "advertiser", operType="/addTicket",keyName="广告")
    @RequestMapping(value = "/addTicket", method = RequestMethod.POST,produces="application/json")
    public ResultModel <Long> addTicket(HttpServletRequest request, HttpServletResponse response,@RequestBody AdTicketDto adTicketDto){
        ResultModel<Long> rs = new ResultModel<Long>();
        try {
            if(adTicketDto == null){
                rs.setSuccessed(false);
                rs.setErrorDesc("提交数据为空");
                return rs;
            }
            if(adTicketDto.getStatus() == null){
                //设置待审核状态
                adTicketDto.setStatus(AdTicket.WAIT_AUDIT);
            }
            //广告主的ae初始化为advertiser关联的ae 如果为空 绑定aeLeader
            AdvertiserDto advertiserDto =  adShopIntegration.findAdShopMsg(adTicketDto.getAdvertiser());
            LOGGER.info(advertiserDto.getAe()+"------------------------------");
            adTicketDto.setAe(advertiserDto.getAe());
            if (StringUtil.isBlank(adTicketDto.getAe())){
                //获取aeleader插入
                List<String> userName = roleService.getUserName("aeleader");
                adTicketDto.setAe(userName.get(0));
            }
            Long id = adTicketService.add(adTicketDto,adTicketDto.getCreateUser());
            try {
                if(id != null && adTicketDto.getAdvertiser() !=null && RedisKeys.advertisers.contains(adTicketDto.getAdvertiser())){
                    jedisUpdater.hupdate(RedisKeys.getPddTickets(),String.valueOf(id),adTicketDto.getAdvertiser());
                }
            }catch (Exception e){
                LOGGER.error("拼多多券入Redis失败" + e.getMessage(),e);
            }
            //嵌入链接测试表数据
            AdTicketUrlTest adTicketUrlTest = new AdTicketUrlTest();
            adTicketUrlTest.setTicketId(id);
            adTicketUrlTest.setActionType((short)0);
            adTicketUrlTest.setDealStatus((short)0);
            adTicketUrlTest.setCreateTime(new Date());
            adTicketUrlTest.setModifyTime(new Date());
            adTicketService.addTicketUrlTest(adTicketUrlTest);
            try{
                //添加日志
                tblAdTicketModifyService.addLog(adTicketDto);
            }catch (Exception e){
                LOGGER.error("新增广告券操作日志失败");
                e.printStackTrace();
            }
            rs.setReturnValue(id);
        }catch (Exception e){
            LOGGER.error("添加广告券出错"+e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("添加广告券出错");
            return rs;
        }
        return rs;
    }
        
        @LogBefore(user = "advertiser", operType="/updateTicket",keyName="广告")
        @RequestMapping(value = "/updateTicket", method = RequestMethod.POST,produces="application/json")
        public ResultModel<Boolean>updateTicket(HttpServletRequest request, @RequestBody AdTicketDto adTicketDto) {
            ResultModel<Boolean> rs = new ResultModel<Boolean>();
            if(adTicketDto==null||adTicketDto.getId()==null){
                return ResultModelFactory.FAIL500("广告券id不能为空");
            }
            //对于进入过正式投放库的券，修改了落地页，审核通过后，券的状态变为修改前的状态
            //修改券——广告主后台是部分字段修改，所以这里必须更新前查一遍数据
            List<AdTicket> adTickets = null;
            AdTicket adTicket = null;
            try {
                adTickets = adTicketService.findByIds(String.valueOf(adTicketDto.getId()));
                if(adTickets == null || adTickets.isEmpty()){
                    return ResultModelFactory.FAIL500("广告券不存在");
                }
                adTicket = adTickets.get(0);
                //记录当前券状态大于0
                if(adTicket.getStatus() != null && adTicket.getStatus() >0){
                    //暂停状态时获取库中的 暂停理由 再次设置进去防止置空
                    //此处判断如果是带启用状态的券 不存lastStatus
                    if (!((short)3==adTicket.getStatus()&&adTicket.getLastStatus()<=0)){
                        adTicketDto.setLastStatus(adTicket.getStatus());
                        //暂停状态时获取库中的 暂停理由 再次设置进去防止置空
                        if((short)2==adTicket.getStatus()){
                            adTicketDto.setPauseReason(adTicket.getPauseReason());
                        }
                    }
                }
                //防止已经为待审核的状态被覆盖
                if(adTicket.getStatus() != null && adTicket.getStatus() == AdTicket.WAIT_AUDIT ){
                    adTicketDto.setStatus(AdTicket.WAIT_AUDIT); 
                }
                if(adTicketService.checkTagNeedAudit(adTicketDto.getId()) && adTicketService.checkTicketAssets(adTicketDto, adTicket,null)){
                    //设置审核状态
                    adTicketDto.setStatus(AdTicket.WAIT_AUDIT);
                    //根据券id查询是否存在记录  存在修改 不存在插入
                    AdTicketUrlTest result = adTicketService.findTicketUrlTest(adTicketDto.getId().longValue());
                    if (null==result){
                        //嵌入链接测试表数据
                        AdTicketUrlTest adTicketUrlTest = new AdTicketUrlTest();
                        adTicketUrlTest.setTicketId(adTicketDto.getId().longValue());
                        adTicketUrlTest.setActionType((short)1);
                        adTicketUrlTest.setDealStatus((short)0);
                        adTicketUrlTest.setCreateTime(new Date());
                        adTicketUrlTest.setModifyTime(new Date());
                        adTicketService.addTicketUrlTest(adTicketUrlTest);
                        LOGGER.info("------广告主链接测试表数据插入----");
                    }else {
                        result.setModifyTime(new Date());
                        result.setActionType((short)1);
                        result.setDealStatus((short)0);
                        adTicketService.updateTicketUrlTest(result);
                        LOGGER.info("------广告主链接测试表数据修改----");
                    }
                }
                //更新前查询一下数据库旧的数据
                AdTicketVo record = adTicketService.findById(adTicketDto.getId().longValue());
                AdTicketDto adTicketDtoParam = new AdTicketDto();
                if(record != null){
                    AdTicketVo updateParam = updateParam(record,adTicketDto);
                    //设置流量包
                    if(CollectionUtils.isNotEmpty(record.getAdFlows())){
                        List<Object> adFlowPackageArrayList = new ArrayList<Object>();
                        for(AdFlowPackageNewVo param : record.getAdFlows()){
                            Map<String, Object> hashMap = new HashMap<String,Object>();
                            hashMap.put("id", param.getId());
                            hashMap.put("flowPackageId", param.getFlowPackageId());
                            hashMap.put("packageName", param.getPackageName());
                            hashMap.put("count", param.getCount());
                            hashMap.put("consume", param.getConsume());
                            if(param.getPrice() != null){
                                Money money = Money.ofLi(param.getPrice());
                                hashMap.put("price", money.getYuan());
                            }else{
                                hashMap.put("price", 0);
                            }
                            hashMap.put("quota", param.getQuota());
                            hashMap.put("ticketId", param.getTicketId());
                            hashMap.put("type", param.getType());
                            adFlowPackageArrayList.add(hashMap);
                        }
                        //当前流量包出价限额信息处理
                        adTicketDtoParam.setFlowPackageArray(JSON.toJSONString(adFlowPackageArrayList));
                    }
                    //流量包的黑白名单
                    List<AdFlowPackageNewVo> flowPageIdByTicket = adTicketFlowNewService.findFlowPageIdByTicket(record.getId().longValue());
                    if(!CollectionUtils.isEmpty(flowPageIdByTicket)){
                        List<Long> ids = new ArrayList<Long>();
                        for(AdFlowPackageNewVo param : flowPageIdByTicket){
                            ids.add(param.getId());
                        }
                        adTicketDtoParam.setFlowPackageIdArray(JSON.toJSONString(ids));
                    }

                    //设置分时段对广告位限制配置
                    if(CollectionUtils.isNotEmpty(record.getPositionTimesLimitConfig())){
                        adTicketDtoParam.setPositionTimesLimitConfig(JSON.toJSONString(record.getPositionTimesLimitConfig()));
                    }
                    BeanUtils.copyProperties(updateParam, adTicketDtoParam);

                    //设置投放控制
                    AdTicketDto.ControlDto controlDto = new AdTicketDto.ControlDto();
                    AdTicketVo.ControlVo controlVo = updateParam.getControlVo();
                    BeanUtils.copyProperties(controlVo, controlDto);
                    adTicketDtoParam.setControlDto(controlDto);

                    //设置ocpc
                    AdTicketOcpcConf ocpcConf = adTicketOcpcService.selectByTicketId(adTicket.getId());
                    if(ocpcConf != null){
                        AdTicketDto.OcpcConfDto ocpcConfDto = new AdTicketDto.OcpcConfDto();
                        ocpcConfDto.setTicketId(ocpcConf.getTicketId());
                        ocpcConfDto.setIsSupportOcpc(ocpcConf.getIsSupportOcpc());
                        if(ocpcConf.getCpaExpectPrice() != null){
                            ocpcConfDto.setCpaExpectPrice(Money.ofLi(ocpcConf.getCpaExpectPrice()).getYuan());
                        }
                        if(ocpcConf.getCpaDeepExpectPrice() != null){
                            ocpcConfDto.setCpaDeepExpectPrice(Money.ofLi(ocpcConf.getCpaDeepExpectPrice()).getYuan());
                        }
                        ocpcConfDto.setCloseThreshold(ocpcConf.getCloseThreshold());
                        ocpcConfDto.setDeepExpectActionType(ocpcConf.getDeepExpectActionType());
                        adTicketDtoParam.setOcpcConf(ocpcConfDto);
                    }
                }
                LOGGER.info("广告券【{}】最终更新的参数为：{}", adTicketDtoParam.getId(), JsonHelper.convert(adTicketDtoParam));
                adTicketService.update(CommonConstant.Opera.Platform.ADVERTISER, adTicketDtoParam, adTicketDtoParam.getCreateUser());
                try {
                    if(adTicketDto.getId() != null && adTicketDto.getAdvertiser() != null && RedisKeys.advertisers.contains(adTicketDto.getAdvertiser())){
                        jedisUpdater.hupdate(RedisKeys.getPddTickets(),String.valueOf(adTicketDto.getId()),adTicketDto.getAdvertiser());
                    }
                }catch (Exception e){
                    LOGGER.error("拼多多券入Redis失败" + e.getMessage(),e);
                }
                rs.setReturnValue(true);
            }catch (Exception e){
                LOGGER.error("更新广告券出错"+e.getMessage(), e);
                return ResultModelFactory.FAIL500("更新广告券出错");
            }
            return  rs;
        }
        
        @RequestMapping(value = "/getTicketById", method = RequestMethod.GET)
        public ResultModel<AdTicketVo> find(@RequestParam(required = true, name = "id") Long id) {
            ResultModel<AdTicketVo> rs = new ResultModel<AdTicketVo>();
            AdTicketVo result = null;
            try {
                result = adTicketService.findById(id);
                rs.setReturnValue(queryResultParam(result));
            }catch (ValidateException v){
                LOGGER.error(v.getMessage(), v);
                return ResultModelFactory.FAIL400(v.getMessage());
            }catch (Exception e){
                LOGGER.error("查找广告券出错"+e.getMessage(), e);
                return ResultModelFactory.FAIL500("查找广告券出错");
            }
            return  rs;
        }

    @RequestMapping(value = "/checkTicketExistAssets", method = RequestMethod.GET)
    public ResultModel<Boolean> checkTicketExistAssets(@RequestParam(name = "id") Long id) {
        ResultModel<Boolean> rs = new ResultModel<>();
        Boolean result = null;
        try {
            result = adTicketAssetsService.checkTicketExistAssets(id);
            rs.setReturnValue(result);
        }catch (Exception e){
            LOGGER.error("查找出错"+e.getMessage(), e);
            return ResultModelFactory.FAIL500("查找出错");
        }
        return  rs;
    }
        
        /**
        * @Title: queryResultParam  
        * @Description: 查询券详情参数封装,返回给广告主
        * @return AdTicketDto 
         */
        public static AdTicketVo queryResultParam(AdTicketVo result){
            AdTicketVo record = null;
            AdTicketVo.ControlVo controlVo = null;
            if(result != null){
                record = new AdTicketVo();
                controlVo = new AdTicketVo.ControlVo();
                //参数封装
                record.setStatus(result.getStatus());
                //主键ID
                record.setId(result.getId());
                //素材ID
                record.setAssetsids(result.getAssetsids());
                //广告主名称
                record.setAdvertiserName(result.getAdvertiserName());
                //广告主ID
                record.setAdvertiser(result.getAdvertiser());
                //广告名称
                record.setName(result.getName());
                //结算类型
                record.setSettleType(result.getSettleType());
                //单价
                record.setPrice(result.getPrice());
                //广告券类型
                record.setType(result.getType());

                //广告券券码类浮标位素材
                record.setAssetscouponsids(result.getAssetscouponsids());
                //票券码类的基本信息
                record.setCouponsInfoVo(result.getCouponsInfoVo());

                //ADX素材
                record.setAssetsadxids(result.getAssetsadxids());
                //ADX信息
                record.setAdxConfVo(result.getAdxConfVo());

                //激励视频素材
                record.setAssetsinspirevideoids(result.getAssetsinspirevideoids());
                //激励视频信息
                record.setInspireVideoConfVo(result.getInspireVideoConfVo());

                //限额的日预算
                if(result.getBudgetDaily() == 999999){
                    //日预算
                    record.setBudgetDaily(null);
                }else{
                    //日预算
                    record.setBudgetDaily(result.getBudgetDaily());
                }
                //投放链接
                record.setUrl(result.getUrl());
                //投放区域
                record.setCitys(result.getCitys());
                if(StringUtil.isNotBlank(result.getCitys())){
                  record.setBooleanCitys(true);
                }
                //投放设备
                record.setOss(result.getOss());
                //投放环境
                record.setIsSupportWechat(result.getIsSupportWechat());
                //投放日期
                record.setValidStartDate(result.getValidStartDate());
                record.setValidEndDate(result.getValidEndDate());
                //投放时间
                if(result.getControlVo()!= null){
                    controlVo.setTimes(result.getControlVo().getTimes());
                    if(StringUtil.isNotBlank(result.getControlVo().getTimes())){
                        controlVo.setBooleanTimes(true);
                    }
                }
                record.setApps(result.getApps());
            }
            record.setControlVo(controlVo);
            return record;
        }
        
        /**
         * @Title: updateParam  
         * @Description: 修改参数封装
         * @return AdTicketDto 
          */
         public static AdTicketVo updateParam(AdTicketVo record,AdTicketDto adTicketDto){
             //素材修改记录的日志
             record.setApps(adTicketDto.getApps());
             record.setLog(adTicketDto.getLog());
             record.setId(adTicketDto.getId());
             record.setAssetsids(null);
            // record.setAssetsids(adTicketDto.getAssetsids());
             record.setPrice(adTicketDto.getPrice());
             record.setAdvertiser(adTicketDto.getAdvertiser());
             record.setCreateUser(adTicketDto.getCreateUser());
             record.setModifyUser(adTicketDto.getCreateUser());
             if(adTicketDto.getStatus() != null && adTicketDto.getStatus() == AdTicket.WAIT_AUDIT ){
                 record.setStatus(AdTicket.WAIT_AUDIT);
             }
             //广告名称
             record.setName(adTicketDto.getName());
             //日预算,不限额就是为null->999999
             if(adTicketDto.getBudgetDaily() == null){
                 record.setBudgetDaily(999999d); 
             }else{
                 record.setBudgetDaily(adTicketDto.getBudgetDaily()); 
             }
             //投放链接,重新审核
             record.setUrl(adTicketDto.getUrl());
             //投放区域
             record.setBooleanCitys(adTicketDto.getBooleanCitys());
             record.setCitys(adTicketDto.getCitys());
             //投放设备
             record.setOss(adTicketDto.getOss());
             //投放环境
             record.setIsSupportWechat(adTicketDto.getIsSupportWechat());
             //投放日期
             record.setValidStartDate(adTicketDto.getValidStartDate());
             record.setValidEndDate(adTicketDto.getValidEndDate());
             //给定默认的权重
             record.setWeight(100d);
             record.setApps(adTicketDto.getApps());
             //投放时间
             if(adTicketDto.getControlDto()!= null){
                 record.getControlVo().setBooleanTimes(adTicketDto.getControlDto().getBooleanTimes());
                 record.getControlVo().setTimes(adTicketDto.getControlDto().getTimes());
             }
             //个推标签
             if(record.getControlVo()!= null){
                 //这里存储的是json字符串
                 String personsGrade = record.getControlVo().getPersonsGrade();
                 LOGGER.info("personsGrade的json串为：" + personsGrade);
                 if (StringUtil.isNotEmpty(personsGrade)) {
                     if ("[]".equals(personsGrade)) {
                         //字符串"[]"是空的json
                         record.getControlVo().setPersonsGrade(null);
                     } else {
                         //转换一下
                         List<AdTicketGetuiTagRef> confs = JSON.parseArray(personsGrade, AdTicketGetuiTagRef.class);
                         if(CollectionUtils.isEmpty(confs)){
                             record.getControlVo().setPersonsGrade(null);
                         } else {
                             StringBuffer buffer = new StringBuffer();
                             //sex-010qww,age-010qqw00-010qqe00,city_level-010qzq00,isp-isp_all
                             for (AdTicketGetuiTagRef conf : confs) {
                                 buffer.append(conf.getTagGroupCode()).append(CommonConstant.BaseCharacter.BAR)
                                         .append(conf.getTagGroupValue().replace(CommonConstant.BaseCharacter.COMMA,CommonConstant.BaseCharacter.BAR))
                                         .append(CommonConstant.BaseCharacter.COMMA);
                             }
                             if (buffer.length() > 0) {
                                 buffer.deleteCharAt(buffer.length() - 1);
                             }
                             LOGGER.info("personsGrade最终格式为：" + buffer.toString());
                             record.getControlVo().setPersonsGrade(buffer.toString());
                         }


                     }
                 }

             }
             return record;
         }


}
