package com.bxm.adsmanager.web.controller.facade;


import com.bxm.adsmanager.facade.model.video.VideoAssetDto;
import com.bxm.adsmanager.facade.model.video.VideoAssetVo;
import com.bxm.adsmanager.service.audit.VideoAssetService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * @Title:AdvertiserQualifyController.java
 * @Package:com.bxm.adsmanager.web.controller.facade
 * @Description: 广告主视频素材操作类
 */
@RestController
@RequestMapping("/advertiser")
public class AdvertiserVideoAssetController {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertiserVideoAssetController.class);

    @Autowired
    VideoAssetService videoAssetService;

    @LogBefore(operType = "/advertiser/videoAsset/saveOrUpdate", keyName = "日志打印测试")
    @RequestMapping(value = "/videoAsset/saveOrUpdate", produces = "application/json")
    public ResultModel saveOrUpdate(@RequestBody VideoAssetDto videoAssetDto) {
        try {
            videoAssetService.add(videoAssetDto);
            // 获取后台用户名
            return ResultModelFactory.SUCCESS();
        } catch (Exception e) {
            LOGGER.error("新增或者修改出错", e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }

    @RequestMapping(value = "/videoAsset/updateStatus", produces = "application/json")
    public ResultModel updateStatus(@RequestParam(value = "status", required = true) Short status,
                                    @RequestParam(value = "id", required = true) Long id,
                                    @RequestParam(value = "userName", required = true) String userName
    ) {
        try {
            // 获取后台用户名
            videoAssetService.updateStatus(id, status, userName);
            return ResultModelFactory.SUCCESS();
        } catch (Exception e) {
            LOGGER.error("修改状态出错", e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }

    /**
     * 查找列表
     *
     * @param pageNum
     * @param pageSize
     * @param keywords
     * @return
     */
    @RequestMapping(value = "/videoAsset/getList", produces = "application/json")
    public ResultModel<PageInfo<VideoAssetVo>> getList(
            @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
            @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize,
            @RequestParam(value = "keywords", required = false) String keywords,
            @RequestBody List<Long> advertiserIds) {
        ResultModel<PageInfo<VideoAssetVo>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(videoAssetService.getListByAdvertiser(keywords, pageNum, pageSize, advertiserIds));
            resultModel.setSuccessed(true);
        } catch (Exception e) {
            LOGGER.error("查找列表出错", e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查找列表出错");
        }
        return resultModel;

    }

    @RequestMapping(value = "/videoAsset/getVideoAsset", produces = "application/json")
    public ResultModel<VideoAssetVo> getVideoAsset(@RequestParam(value = "id", required = true) Long id,
                                                   @RequestParam(value = "advertiserId", required = true) Long advertiserId
    ) {
        ResultModel<VideoAssetVo> resultModel=new ResultModel<>();
        try {
            resultModel.setReturnValue( videoAssetService.getVideoAssetVo(id, null));
            return resultModel;
        } catch (Exception e) {
            LOGGER.error("修改状态出错", e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }
}
