package com.bxm.adsmanager.web.controller.facade;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.facade.model.position.PositionAuditPassDataHandleDTO;
import com.bxm.adsmanager.facade.service.AppEntranceFacadeService;
import com.bxm.adsmanager.service.adkeeper.AdAssetsTemplateService;
import com.bxm.adsmanager.service.adposition.AdPositionAuditService;
import com.bxm.adsmedia.facade.model.provider.FirstProviderAuditDto;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;

/**
 * <p>
 * 广告位处理
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-10-09
 */
@RestController
public class AppEntranceFacadeServiceImpl implements AppEntranceFacadeService {

    private static final Logger LOGGER = LoggerFactory.getLogger(AppEntranceFacadeServiceImpl.class);

    @Autowired
    private AdPositionAuditService adPositionAuditService;
    @Autowired
    private AdAssetsTemplateService adAssetsTemplateService;


    @Override
    public ResultModel<Boolean> auditPassDataHandle(@RequestBody PositionAuditPassDataHandleDTO dto) {
        PositionAuditPassDataHandleDTO.FirstProviderAuditDto auditDto = dto.getFirstProviderAuditDto();

        boolean isRiskController = dto.isRiskController();
        Boolean auditPass = dto.getAuditPass();

        FirstProviderAuditDto firstProviderAuditDto = new FirstProviderAuditDto();
        BeanUtils.copyProperties(auditDto, firstProviderAuditDto);

        return ResultModelFactory.SUCCESS(adPositionAuditService.auditPassDataHandle(firstProviderAuditDto, isRiskController, auditPass));
    }

    @Override
    public ResultModel<Boolean> updateAssetsTemplateAssociationsPositionNum() {
        adAssetsTemplateService.updateAssetsTemplateAssociationsPositionNum();
        return ResultModelFactory.SUCCESS(Boolean.TRUE);
    }
}
