package com.bxm.adsmanager.web.controller.facade;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */


import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.integration.adsprod.service.ProdAdvertiserIntegration;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketCostLog;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketCouponsCode;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdTicketThirdPartyCrowdPackageDto;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmanager.service.adkeeper.AdTicketCostService;
import com.bxm.adsmanager.service.adkeeper.AdTicketCouponsCodeService;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.service.adkeeper.AdTicketThirdPartyCrowdPackageService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.adsprod.facade.media.Position;
import com.bxm.adsprod.facade.ticket.TicketProfitForCpa;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

/**
 * <h3>供adsprod调用更新广告券状态</h3>
 * <p>//todo 这里后面可能做参数验证，权限拦截过滤 以及是否要移到 facade  项目中</p>
 * @author hcmony
 * @since V1.0.0, 2017/12/14 19:11
 */
@RestController
@RequestMapping("/adsmanager")
public class FacadeTicketController extends BaseController {

	private static final Logger LOGGER = LoggerFactory.getLogger(FacadeTicketController.class);

	@Autowired
	private AdTicketService adTicketService;
	@Autowired
	private AdTicketCostService adTicketCostService;
	@Autowired
	private AdTicketCouponsCodeService adTicketCouponsCodeService;
	@Autowired
	private AdTicketThirdPartyCrowdPackageService adTicketThirdPartyCrowdPackageService;

	@Autowired
	private ProdAdvertiserIntegration prodAdvertiserIntegration;
	@Autowired
	private ProdPusherIntegration prodPusherIntegration;

	/**
	 * @description adsprod更新广告券状态
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @deprecated  这个方法是借adsprod-service 调用
	 * @return java.lang.Object
	 */
	@LogBefore(user = "adsprod",operType="/adsmanager/updateAdTicket",keyName="广告")
	@RequestMapping(value = "/updateAdTicket", method = RequestMethod.POST)
	public ResultModel update(HttpServletRequest request, HttpServletResponse response,
							  @RequestParam(required = true, name = "id" ) Long id,
							  @RequestParam(required = true, name = "reason") Integer reason,
							  @RequestParam(required = true,name = "status") Short status) {

		//状态。0 停止、1 正常、2 暂停、-1 已删除
		//暂停原因。1- 超出预算、2- 余额不足;3-未到投放日期;4-投放结束
		response.setHeader("Access-Control-Allow-Origin", "*");

		ResultModel rs = new ResultModel();
		try {
			AdTicket adTicket = new AdTicket();
			adTicket.setId(id);
			adTicket.setStatus(status);
			adTicket.setPauseReason(reason);
			adTicket.setModifyUser("前端系统判断");
			LOGGER.info("adsprod请求更新广告券状态:id="+id+",status="+status+",reason="+reason);
			Integer result = adTicketService.facadeUpdateStatus(adTicket);

			User user = getUser(request,response);
			user.setUsername("adsprod前端出券系统");
			user.setRoleCodes(Lists.newArrayList("adsprod前端出券系统"));
			//日志记录
			addLogs(user, JSON.toJSONString(AdTicket.AdTicketStatus.getName(status)+
					"广告券，原因:"+AdTicket.AdTicketPAUSE.getName(reason)),id+"");

			rs.setReturnValue(result);
		}catch (Exception e){
			LOGGER.error("adsprod更新广告券状态出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL();
		}
		return  rs;
	}

	@RequestMapping("/plusAdvertiserBalance")
	public ResultModel<Long> plusAdvertiserBalance(@RequestParam("id") Long id, @RequestParam("value") Long value) {
		try {
			Long balance = prodAdvertiserIntegration.incrementBalance(BigInteger.valueOf(id), value);
			return ResultModelFactory.SUCCESS(balance);
		} catch (Exception e) {
				LOGGER.error("pushAdvertiserBalance:", e);

			return ResultModelFactory.FAIL500(e.getMessage());
		}
	}

	@RequestMapping(value = "/pushCpaProfitData", method = RequestMethod.POST)
	public ResultModel<?> pushCpaProfitData(@RequestBody List<TicketProfitForCpa> data) {
		try {
			String rst = prodPusherIntegration.pushToProd(ProdServiceNameEnum.TICKET_PROFIT_FOR_CPA.getServiceName(), Maps.newHashMap(), JsonHelper.convert2bytes(data));
			if (StringUtils.isBlank(rst)) {
				return ResultModelFactory.FAIL500("Push failed!");
			}
			return ResultModelFactory.SUCCESS();
		}catch (Exception e){
			return ResultModelFactory.FAIL500("Push failed!");
		}
	}

	@RequestMapping(value = "/pushPosition/{id}", method = RequestMethod.POST)
	public ResultModel<?> pushPosition(@PathVariable("id") String positionId,
									   @RequestBody Position position) {
		try {
			Map<String, Object> parameter = Maps.newHashMap();
			parameter.put(ProdServiceNameEnum.POSITION.getParameters(), positionId);
			String rst = prodPusherIntegration.pushToProd(ProdServiceNameEnum.POSITION.getServiceName(), parameter, JsonHelper.convert2bytes(position));
			if (StringUtils.isBlank(rst)) {
				return ResultModelFactory.FAIL500("Push failed!");
			}
			return ResultModelFactory.SUCCESS();
		}catch (Exception e){
			return ResultModelFactory.FAIL500("Push failed!");
		}
	}

	@RequestMapping(value = "/addTicketCostLog",method = RequestMethod.POST)
	public ResultModel addTicketCostLog(@RequestBody AdTicketCostLog adTicketCostLog) {

		ResultModel resultModel = new ResultModel<>();
		try {
			resultModel.setSuccessed(adTicketCostService.insert(adTicketCostLog));
		} catch (Exception e) {
			LOGGER.error("券提醒记录添加失败",e);
			return ResultModelFactory.FAIL500("券提醒记录添加失败");
		}
		return resultModel;
	}

	/**
	 *  adsprod更新优惠券码的信息,这个方法是借adsprod-service 调用
	 * @param request
	 * @param response
	 * @param ticketId
	 * @param status
	 * @param firstShowTime
	 * @param useTime
	 * @param usePositionId
	 * @param bindDeviceNo
	 * @param couponsCode
	 * @return
	 */
	@LogBefore(user = "adsprod",operType="/adsmanager/updateTicketCouponsCode",keyName="广告")
	@RequestMapping(value = "/updateTicketCouponsCode", method = RequestMethod.POST)
	public ResultModel updateTicketCouponsCode(HttpServletRequest request, HttpServletResponse response,
											   @RequestParam(required = true, name = "ticketId") Long ticketId,
											   @RequestParam(required = true, name = "status") Short status,
											   @RequestParam(required = false, name = "firstShowTime") Long firstShowTime,
											   @RequestParam(required = false, name = "useTime") Long useTime,
											   @RequestParam(required = true, name = "usePositionId") String usePositionId,
											   @RequestParam(required = true, name = "bindDeviceNo") String bindDeviceNo,
											   @RequestParam(required = true, name = "couponsCode") String couponsCode) {

		//状态。0 停止、1 正常、2 暂停、-1 已删除`
		//暂停原因。1- 超出预算、2- 余额不足;3-未到投放日期;4-投放结束
		response.setHeader("Access-Control-Allow-Origin", "*");

		ResultModel rs = new ResultModel();
		try {
			AdTicketCouponsCode adTicketCouponsCode = new AdTicketCouponsCode();
			adTicketCouponsCode.setTicketId(ticketId);
			adTicketCouponsCode.setStatus(status);
			if(firstShowTime != null){
				adTicketCouponsCode.setFirstShowTime(new Date(firstShowTime));
			}
			if(useTime != null) {
				adTicketCouponsCode.setUseTime(new Date(useTime));
			}
			adTicketCouponsCode.setUsePositionId(usePositionId);
			adTicketCouponsCode.setBindDeviceNo(bindDeviceNo);
			adTicketCouponsCode.setCouponsCode(couponsCode);
			adTicketCouponsCode.setCreateUser("前端系统判断");
			adTicketCouponsCode.setModifyUser("前端系统判断");
			adTicketCouponsCode.setModifyTime(new Date());
			Integer result = adTicketCouponsCodeService.facadeUpdateTicketCouponsCode(adTicketCouponsCode);

			User user = getUser(request,response);
			user.setUsername("adsprod前端出券系统");
			user.setRoleCodes(Lists.newArrayList("adsprod前端出券系统"));
			//日志记录
			addLogs(user, JSON.toJSONString(couponsCode + "券码信息更新"), ticketId+"");

			rs.setReturnValue(result);
		}catch (Exception e){
			LOGGER.error("adsprod更新广告券优惠券码出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL();
		}
		return  rs;
	}

	/**
	 * 获取人群包信息
	 * @param projectType
	 * @param packageSource
	 * @return
	 */
	@LogBefore(user = "adsprod",operType="/adsmanager/adTicketThirdPartyCrowdPackage/getList", keyName="广告")
	@RequestMapping(value = "/adTicketThirdPartyCrowdPackage/getList", method = RequestMethod.POST)
	public ResultModel getThirdPartyCrowdPackageList(@RequestParam(required = false, name = "projectType") Short projectType,
													 @RequestParam(required = false, name = "packageSource") Short packageSource) {
		ResultModel rs = new ResultModel();
		try {
			AdTicketThirdPartyCrowdPackageDto adTicketThirdPartyCrowdPackageDto = new AdTicketThirdPartyCrowdPackageDto();
			adTicketThirdPartyCrowdPackageDto.setProjectType(projectType);
			adTicketThirdPartyCrowdPackageDto.setPackageSource(packageSource);
			rs.setReturnValue(adTicketThirdPartyCrowdPackageService.getList(adTicketThirdPartyCrowdPackageDto));
		}catch (Exception e){
			LOGGER.error("adsprod获取人群包配置出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL();
		}
		return rs;
	}
}
