package com.bxm.adsmanager.web.controller.facade;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdAssetsTemplateContentMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.PanguCreativeMapperExt;
import com.bxm.adsmanager.facade.service.PanguCreativeFacadeService;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplateContentExample;
import com.bxm.adsmanager.model.dao.adkeeper.PanguCreative;
import com.bxm.adsmanager.model.dao.adkeeper.PanguCreativeExample;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.PanguCreativeDTO;
import com.bxm.adsmanager.service.adkeeper.PanguCreativeService;
import com.bxm.adsmanager.utils.GifDecoder;
import com.bxm.util.AliOSSUtil;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.DigestUtils;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.List;

/**
 * @author zhangdong
 * @date 2022/11/17
 */
@RestController
public class PanguCreativeFacadeServiceImpl implements PanguCreativeFacadeService {

    @Autowired
    private PanguCreativeService panguCreativeService;

    @Autowired
    private PanguCreativeMapperExt panguCreativeMapperExt;

    @Autowired
    private AdAssetsTemplateContentMapper adAssetsTemplateContentMapper;

    private String bucketName = "bxm-guide";
    private String fileHost = "https://buyimg.bianxianmao.com/";
    private String accessKeyId = "LTAIdRl4etA0hXJt";
    private String secret = "oVazl7iJufs7QfGJBuGWoIkJTjIjUa";


    @Override
    public String upload(MultipartFile file) throws Exception {
        if (file == null) {
            return null;
        }
        String md5 = DigestUtils.md5DigestAsHex(file.getBytes());
        //需要查找盘古素材库是否存在
        PanguCreativeExample panguCreativeExample = new PanguCreativeExample();
        panguCreativeExample.createCriteria().andMd5EqualTo(md5);
        List<PanguCreative> creatives = panguCreativeMapperExt.selectByExample(panguCreativeExample);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(creatives)) {
            return creatives.get(0).getPicture();
        }
        String url;
        //盘古素材库不存在 上传数据
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(file.getBytes())) {
            url = AliOSSUtil.upload(accessKeyId, secret, inputStream, bucketName, fileHost, null);
        }
        //需要在盘古素材库插入数据
        int width;
        int height;
        String fileName = file.getOriginalFilename();
        if (StringUtils.isEmpty(fileName)) {
            fileName = ".jpg";
        }
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
        if ("gif".equalsIgnoreCase(suffix)) {
            GifDecoder.GifImage sourceImg = GifDecoder.read(file.getInputStream());
            width = sourceImg.getWidth();
            height = sourceImg.getHeight();
        } else {
            BufferedImage sourceImg = ImageIO.read(file.getInputStream());
            width = sourceImg.getWidth();
            height = sourceImg.getHeight();
        }
        AdAssetsTemplateContentExample adAssetsTemplateContentExample = new AdAssetsTemplateContentExample();
        adAssetsTemplateContentExample.createCriteria().andPictureConstraintsLike(width + "-" + height + "%");
        int assetsTemplateContentCount = adAssetsTemplateContentMapper.countByExample(adAssetsTemplateContentExample);
        if (assetsTemplateContentCount == 0) {
            return url;
        }
        PanguCreativeDTO dto = new PanguCreativeDTO();
        PanguCreativeDTO.Creative creative = new PanguCreativeDTO.Creative();
        creative.setFormat(suffix.toUpperCase());
        creative.setPicture(url);
        creative.setMd5(md5);
        creative.setSize(width + "*" + height);
        dto.setCreatives(Lists.newArrayList(creative));
        User user = new User();
        user.setUsername("facade sync creative");
        panguCreativeService.add(user, dto);
        return url;
    }
}
