package com.bxm.adsmanager.web.controller.facade;

import com.bxm.adsmanager.model.vo.AdTicketIncomePositionVo;
import com.bxm.adsmanager.service.adprofit.AdTicketIncomePositionService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

/**
 * <h3>Shenjue.java基本描述</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/06/26 09:53
 */
@RequestMapping("/adsmanager")
@RestController
public class PositionProfitController {

    private static final Logger LOGGER = LoggerFactory.getLogger(PositionProfitController.class);

    @Autowired
    private AdTicketIncomePositionService incomePositionService;


    @RequestMapping("/findPositionProfit")
    public ResultModel findPositionProfit(@RequestParam(name = "appKey") String appKey,
                                          @RequestParam(name = "datetime", required = false) String datetime) {
        try {
            ResultModel rs = new ResultModel();
            Map<String, Object> map = Maps.newHashMap();
            map.put("datetime", datetime);
            map.put("appId", appKey);
            List<AdTicketIncomePositionVo> list = incomePositionService.findAllByType(map);
            rs.setReturnValue(list);
            return rs;
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return ResultModelFactory.FAIL();
        }
    }
}
