package com.bxm.adsmanager.web.controller.facade;

import com.bxm.adsmanager.service.media.MediaPositionDirectTicketService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * Created by wuwenquan on 2018/10/12.
 */
@RequestMapping("/adsmanager")
@RestController
public class PositionSizePushController {

    private static final Logger LOGGER = LoggerFactory.getLogger(PositionSizePushController.class);

    @Autowired
    private MediaPositionDirectTicketService mediaPositionDirectTicketService;

    @RequestMapping(value = "/positionSizePush",method = RequestMethod.GET)
    @ResponseBody
    public void pushPositionSize(@RequestParam(name = "positionSize") String positionSize,
                                            @RequestParam(name = "positionId") String positionId){
        try {
            mediaPositionDirectTicketService.websitePushPositionSize(positionSize,positionId);
        } catch (Exception e) {
            LOGGER.error(e.getMessage(),e);
        }

}
    }
