package com.bxm.adsmanager.web.controller.facade;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.facade.model.precharge.PrechargeCorrectSearchDTO;
import com.bxm.adsmanager.facade.model.precharge.PrechargeDTO;
import com.bxm.adsmanager.facade.service.PrechargeFacadeService;
import com.bxm.adsmanager.service.precharge.PrechargeCorrectService;
import com.bxm.adsmanager.service.precharge.PrechargeDetailService;
import com.bxm.adsmanager.service.precharge.PrechargeService;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import com.bxm.warcar.validate.ValidateException;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;

/**
 * @author tangx
 * @date 2020/5/14 16:41
 */
@RestController
@Slf4j
public class PrechargeFacadeServiceImpl implements PrechargeFacadeService {

    @Autowired
    private PrechargeService prechargeService;

    @Autowired
    private PrechargeDetailService prechargeDetailService;

    @Autowired
    private PrechargeCorrectService prechargeCorrectService;


    @Override
    public ResultModel listPrechargeConfig(@RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                           @RequestParam(value = "pageSize", required = false, defaultValue = "20") Integer pageSize,
                                           @RequestParam("account") String account,
                                           @RequestParam(value = "providerKeyword",required = false) String providerKeyword,
                                           @RequestParam(value ="dateTime",required = false) String dateTime,
                                           @RequestParam(value = "mjs",required = false) String mjs,
                                           @RequestParam(value = "bds",required = false) String bds,
                                           @RequestParam(value = "areaType", required = false, defaultValue = "0") Integer areaType) {
        return ResultModelFactory.SUCCESS(prechargeService.listPrechargeConfig(pageNum, pageSize, account,
                providerKeyword, null,dateTime, mjs, bds));
    }

    @Override
    public ResultModel listRechargeDetail(@RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                          @RequestParam(value = "pageSize", required = false, defaultValue = "20") Integer pageSize,
                                          @RequestParam("startTime") String startTime,
                                          @RequestParam("endTime") String endTime,
                                          @RequestParam("accountId") Long accountId) {
        return ResultModelFactory.SUCCESS(prechargeDetailService.listRechargeDetail(pageNum, pageSize, startTime, endTime, accountId));
    }

    @Override
    public Boolean rechargeBalance(@RequestParam("accountId") Long accountId,
                                   @RequestParam("amount") BigDecimal amount,
                                   @RequestParam("datetime") String datetime,
                                   @RequestParam("currentUser") String currentUser) {
        return prechargeService.rechargeBalance(accountId, amount, datetime, currentUser);
    }

    @Override
    public PageInfo getCorrectRecordList(@RequestBody PrechargeCorrectSearchDTO dto) {
        return prechargeCorrectService.getRecordList(dto);
    }

    @Override
    public Boolean correctAudit(@RequestParam("correctId") Long correctId,
                                @RequestParam("auditStatus") Byte auditStatus,
                                @RequestParam(value = "refuseReason", required = false) String refuseReason,
                                @RequestParam("auditUser") String auditUser) {
        return prechargeCorrectService.correctAudit(correctId, auditStatus, refuseReason, auditUser);
    }

    @Override
    public ResultModel<Boolean> updateProviderEndDate(Long accountId, String providers) {
        ResultModel resultModel = new ResultModel();
        try {
            prechargeService.updateProviderEndDate(accountId, providers);
            resultModel.setReturnValue(true);
            resultModel.setSuccessed(true);
        } catch (BusinessException e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc(e.getMessage());
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("系统错误");
        }
        return resultModel;
    }


    /**
     * 账户编辑
     * @param dto
     * @return
     */
    @Override
    public ResultModel addPrechargeConfig(@RequestBody PrechargeDTO dto) {

        try {
            prechargeService.addPrechargeConfig(dto);
        } catch (BusinessException e) {
            return ResultModelFactory.FAILED500(e.getMessage());
        } catch (ValidateException e) {
            return ResultModelFactory.FAILED400(e.getMessage());
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return ResultModelFactory.FAILED500("服务器错误");
        }
        return ResultModelFactory.SUCCESS();
    }

    /**
     * 账户编辑
     * @param dto
     * @return
     */
    @Override
    public ResultModel updatePrechargeConfig(@RequestBody PrechargeDTO dto) {

        try {
            prechargeService.updatePrechargeConfig(dto);
        } catch (BusinessException e) {
            return ResultModelFactory.FAILED500(e.getMessage());
        } catch (ValidateException e) {
            return ResultModelFactory.FAILED400(e.getMessage());
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return ResultModelFactory.FAILED500("服务器错误");
        }
        return ResultModelFactory.SUCCESS();
    }


}
