package com.bxm.adsmanager.web.controller.facade;
import com.bxm.adsmanager.model.dao.prize.TblAdPrize;
import com.bxm.adsmanager.service.prize.PrizeService;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;



/**
 * 广告落地页领取数据校验、添加、统计、导出
 * @author sunzhongshu
 * @version v1.1.4_Report
 * @fileName com.bxm.adsmanager.web.controller.facade.IncomeController.java
 * @CopyRright (c) 2018-杭州微财科技有限公司
 * @created 2018-05-07 18:30:00
 */
@RestController
@RequestMapping("/common")
public class PrizeController {

    @Autowired
    private PrizeService prizeService;

    private static final String ONE="1";
    private static final String TEN="10";

    /**
     *  奖品落地页新增
     * @CopyRright  (c) 2018-微财科技有限公司
     * @author sunzhongshu
     * @created 2018/5/8 9:42
     * @modifier sunzhongshu
     */
    @RequestMapping(value = "/prize/add")
    @ResponseBody
    public ResultModel<Boolean> prizeInsert(@RequestParam(name = "activityId") String activityId,
                                            @RequestParam(name = "activityName") String activityName,
                                            @RequestParam(name = "prizeName") String prizeName,
                                            @RequestParam(name = "telephone") String telephone,
                                            @RequestParam(name = "token") String token){


        return prizeService.prizeInsert(activityId,activityName,prizeName,telephone,token);
    }


    /**
     *  奖品落地页分页查询
     * @CopyRright  (c) 2018-微财科技有限公司
     * @author sunzhongshu
     * @created 2018/5/8 10:56
     * @modifier sunzhongshu
     */

    @RequestMapping(value = "/prize/find")
    @ResponseBody
    public ResultModel<PageInfo<TblAdPrize>> prizeFindPage(@RequestParam(name = "dateTime") String dateTime,
                                              @RequestParam(name = "pageNum",defaultValue = ONE) int pageNum,
                                              @RequestParam(name = "pageSize",defaultValue = TEN) int pageSize,
                                              @RequestParam(name = "keyWords") String keyWords){

        ResultModel<PageInfo<TblAdPrize>> resultModel = new ResultModel<>();
        resultModel.setReturnValue(prizeService.prizeFindPage(dateTime,keyWords,pageNum,pageSize));
        resultModel.setSuccessed(true);
        return resultModel;
    }




}
