package com.bxm.adsmanager.web.controller.facade;

import com.bxm.adsmanager.service.advertiser.TblStationUserWeightService;
import com.bxm.adsmanager.service.advertiser.context.StationUserWeightContext;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * <h3>Shenjue.java基本描述</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2019/04/10 09:53
 */
@Slf4j
@RestController
public class StationUserWeightFacadeController{

    @Autowired
    private TblStationUserWeightService tblStationUserWeightService;

    /**
     * 权重计划完成
     * @return
     */
    @RequestMapping(value = "/stationUserWeight/complete", method = RequestMethod.POST)
    public ResultModel complete(@RequestParam(name = "stationUserWeightId") Long stationUserWeightId) {
        if (null == stationUserWeightId) {
            return ResultModelFactory.FAIL400("stationUserWeightId cant be null！");
        }
        try {
            tblStationUserWeightService.complete(stationUserWeightId);
            return ResultModelFactory.SUCCESS();
        } finally {
            StationUserWeightContext.remove();
        }
    }
}
