package com.bxm.adsmanager.web.controller.income;

import com.bxm.adsmanager.integration.adsmedia.cashapply.CashApplyLogFacadeIntegration;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.adsmedia.facade.model.cashapplylog.CashApplyLogPageDto;
import com.bxm.adsmedia.facade.model.cashapplylog.CashApplyLogPageSearchDto;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Collections;

/**
 * @author: zm
 * @date: 2019-09-26 14:12
 * @Description: 开发者提现记录
 */
@RestController
public class ProviderCashApplyController extends BaseController {


    @Autowired
    private CashApplyLogFacadeIntegration cashApplyLogFacadeIntegration;


    /**
     * 搜索开发者提现记录
     *
     * @param companyName    公司名
     * @param providerName   开发者名称
     * @param state          状态
     * @param mjCode         mjcode
     * @param bdCode         bdCode
     * @param applyStartTime 申请开始时间
     * @param applyEndTime   申请结束时间
     * @param pageSize       分页条数
     * @param pageNum        页码
     * @return
     */
    @GetMapping(value = "/provider/cashApply/list")
    public ResultModel<PageInfo<CashApplyLogPageDto>> getPageCashApplyLog(HttpServletRequest request,
                                                                          HttpServletResponse response,
                                                                          @RequestParam(value = "companyName", required = false) String companyName,
                                                                          @RequestParam(value = "providerName", required = false) String providerName,
                                                                          @RequestParam(value = "state", required = false) String state,
                                                                          @RequestParam(value = "mjCode", required = false) String mjCode,
                                                                          @RequestParam(value = "bdCode", required = false) String bdCode,
                                                                          @RequestParam(value = "applyStartTime", required = false) String applyStartTime,
                                                                          @RequestParam(value = "applyEndTime", required = false) String applyEndTime,
                                                                          @RequestParam(value = "pageSize", required = false) Integer pageSize,
                                                                          @RequestParam(value = "pageNum", required = false) Integer pageNum) {
        User user = getUser(request, response);
        if (user.getRoleCodes() == null) {
            user.setRoleCodes(Collections.EMPTY_LIST);
        }
        //媒介经理和BD经理可以看到所有的
        boolean mjLeader = user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode());
        boolean bdLeader = user.getRoleCodes().contains(RoleEnum.BDLEADER.getCode());
        boolean isMj=false;
        boolean isBd=false;
        if (!mjLeader) {
            if (user.getRoleCodes().contains(RoleEnum.MJ.getCode())) {
                mjCode = user.getUsername();
                isMj=true;
            }
        }
        if (!bdLeader) {
            if (user.getRoleCodes().contains(RoleEnum.BD.getCode())) {
                bdCode = user.getUsername();
                isBd=true;
            }
        }
        CashApplyLogPageSearchDto searchDto = new CashApplyLogPageSearchDto();
        searchDto.setPageSize(pageSize);
        searchDto.setPageNum(pageNum);
        searchDto.setBdCode(bdCode);
        searchDto.setMjCode(mjCode);
        if (isBd&&isMj){
            searchDto.setBdAndMj(true);
        }
        searchDto.setProviderName(providerName);
        searchDto.setState(state);
        searchDto.setCompanyName(companyName);
        searchDto.setApplyStartTime(applyStartTime);
        searchDto.setApplyEndTime(applyEndTime);
        PageInfo<CashApplyLogPageDto> cashApplyLogList = cashApplyLogFacadeIntegration.getCashApplyLogList(searchDto);
        return ResultModelFactory.SUCCESS(cashApplyLogList);
    }
}
