package com.bxm.adsmanager.web.controller.logs;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.integration.logs.LogsIntegration;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.log.facade.dao.LogModel;
import com.bxm.log.facade.dao.Page;
import com.bxm.log.facade.dto.CollectionName;
import com.bxm.log.facade.dto.LogModelDto;
import com.bxm.util.dto.ResultModel;
import lombok.Data;
import lombok.ToString;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.SelectKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <h3>供adsprod调用更新广告券状态</h3>
 * @author hcmony
 * @since V1.0.0, 2018/04/25 19:11
 */
@RestController
@RequestMapping("/logs")
@Slf4j
public class LogsController extends BaseController{

    private static final Logger LOGGER = LoggerFactory.getLogger(LogsController.class);

    @Autowired
    private LogsIntegration logsIntegration;

    @RequestMapping("/find")
    public ResultModel<Page<LogModel>> dealAppCash(HttpServletRequest request, HttpServletResponse response ,
                                                           @RequestParam(name = "adticketId",required = false) String adticketId,
                                                           @RequestParam(name = "startTime",required = true) Long startTime,
                                                           @RequestParam(name = "endTime",required = true) Long endTime,
                                                           @RequestParam(name = "pageNum",required = false) Integer pageNum,
                                                           @RequestParam(name = "pageSize",required = false) Integer pageSize,
                                                           @RequestParam(name = "logInfo",required = false) String logInfo){
        ResultModel<Page<LogModel>> resultModel = new ResultModel<Page<LogModel>>();
        try {
            LogModelDto dto = new LogModelDto();
            dto.setPageNum(pageNum);
            dto.setPageSize(pageSize);
            dto.setStartDateTime(startTime);
            dto.setEndDateTime(endTime);
            dto.setAdticketId(adticketId);
            dto.setLogInfo(logInfo);
            dto.setCollectionName(CollectionName.ADSMANAGER);
            resultModel.setReturnValue(logsIntegration.find(dto));
        } catch (Exception e) {
            LOGGER.error(e.getMessage(),e);
            resultModel.setSuccessed(false);
            resultModel.setErrorCode(e.getMessage());
        }
        return resultModel;
    }

    /**
     * @description 供外部调用 用户日志 记录
     */
    @PostMapping("/addLogs")
    public void add(@RequestBody @Validated AddLogDto addLogDto) {
        log.info("外部调用记录日志参数：{}" , JSON.toJSONString(addLogDto));
        try {
            String ticketId = addLogDto.getTicketId();
            if (StringUtils.isNotBlank(ticketId)) {
                String[] ticketIds = ticketId.split(",");
                for (String id : ticketIds) {
                    String userAccount = "-";
                    LogModel logModel = new LogModel.Builder()
                            .userName(userAccount)
                            .userAccount("系统")
                            .parentAccount(userAccount)
                            .content(addLogDto.getContent())
                            .adticketId(id)
                            .ip("-")
                            .build();
                    logsIntegration.add(logModel);
                }
            }
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
        }
    }



    @Data
     static class AddLogDto implements Serializable {
        private String content;
        private String ticketId;
    }

}
