package com.bxm.adsmanager.web.controller.media;

import com.bxm.adsmanager.integration.adsmedia.media.MediaCommonConfigFacadeIntegration;
import com.bxm.adsmedia.facade.model.positionclasstype.PositionClassTypeDto;
import com.bxm.adsmedia.facade.model.positionclasstype.PositionClassTypeRo;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
* @Title:MediaCommonConfigController.java
* @Package:com.bxm.adsmanager.web.controller.media
* @Description: 媒体相关配置类
 */
@RestController
@RequestMapping("/media")
public class MediaCommonConfigController {

    @Autowired
    private MediaCommonConfigFacadeIntegration mediaCommonConfigFacadeIntegration;

    /**
     * @Title: queryPositionClassTypeList  
     * @Description: 查询媒体相关配置列表
     * @param parentId 父ID
     * @param typeCode 所属分类
     * @param name 标签名称
     * @return ResultModel<List<PositionClassType>> 
      */
    @RequestMapping(value = "/mediaConfigList", method = RequestMethod.GET)
    public ResultModel<List<PositionClassTypeRo>> queryPositionClassTypeList(
            @RequestParam(value = "parentId", required = false, defaultValue = "0") Long parentId,
            @RequestParam(value = "typeCode") String typeCode,
            @RequestParam(value = "name", required = false) String name) {
        PositionClassTypeDto param = new PositionClassTypeDto();
        param.setParentId(parentId);
        param.setTypeCode(typeCode);
        param.setName(name);
        return mediaCommonConfigFacadeIntegration.queryPositionClassTypeList(param);
    }

    /**
     * @Title: queryPositionClassTypePageList  
     * @Description: 查询媒体相关配置列表(分页)
     * @param parentId 父ID
     * @param typeCode 所属分类
     * @param name 标签名称
     * @return ResultModel<PageInfo<PositionClassType>> 
      */
    @RequestMapping(value = "/mediaConfigPageList", method = RequestMethod.GET)
    public ResultModel<PageInfo<PositionClassTypeRo>> queryPositionClassTypePageList(
            @RequestParam(value = "parentId", required = false, defaultValue = "0") Long parentId,
            @RequestParam(value = "typeCode") String typeCode,
            @RequestParam(value = "name", required = false) String name,
            @RequestParam(value = "pageNum", required = true) Integer pageNum,
            @RequestParam(value = "pageSize", required = true) Integer pageSize) {
        PositionClassTypeDto param = new PositionClassTypeDto();
        param.setParentId(parentId);
        param.setTypeCode(typeCode);
        param.setName(name);
        param.setPageNum(pageNum);
        param.setPageSize(pageSize);
        return mediaCommonConfigFacadeIntegration.queryPositionClassTypePageList(param);
    }

    /**
    * @Title: getPositionClassTypeById  
    * @Description:根据主键查询媒体配置信息 
    * @param id
    * @return ResultModel<PositionClassType> advanceAppFlowRecordIntegration
     */
    @RequestMapping(value = "/getById", method = RequestMethod.GET)
    public ResultModel<PositionClassTypeRo> getPositionClassTypeById(@RequestParam(value = "id") Long id) {
        return mediaCommonConfigFacadeIntegration.getPositionClassTypeById(id);
    }

    /**
     * @Title: updatePositionClassTypeById  
     * @Description:根据主键更新媒体配置信息 
     * @param  positionClassType
     * @return ResultModel<Boolean> 
      */
    @LogBefore(operType = "/media/config", keyName = "更新媒体配置信息")
    @RequestMapping(value = "/config", method = RequestMethod.PUT)
    public ResultModel<Boolean> updatePositionClassTypeById(HttpServletRequest request,PositionClassTypeRo positionClassType) {
        ResultModel<Boolean> resultModel = new ResultModel<>();
        if (null == positionClassType || (positionClassType != null && positionClassType.getId() == null)) {
            resultModel.setSuccessed(false);
            resultModel.setReturnValue(false);
            resultModel.setErrorDesc("ID不能为空");
            return resultModel;
        }
        return mediaCommonConfigFacadeIntegration.updatePositionClassTypeById(positionClassType);
    }

    /**
    * @Title: addPositionClassType  
    * @Description: 新增媒体配置信息
    * @param positionClassType
    * @return ResultModel<Boolean> 
     */
    @LogBefore(operType = "/media/config", keyName = "新增媒体配置信息")
    @RequestMapping(value = "/config", method = RequestMethod.POST)
    public ResultModel<Boolean> addPositionClassType(HttpServletRequest request,PositionClassTypeRo positionClassType) {
        ResultModel<Boolean> resultModel = new ResultModel<>();
        if (null == positionClassType || (positionClassType != null && positionClassType.getParentId() == null)) {
            resultModel.setSuccessed(false);
            resultModel.setReturnValue(false);
            resultModel.setErrorDesc("parentId不能为空");
            return resultModel;
        }
        if (StringUtils.isBlank(positionClassType.getTypeCode())) {
            resultModel.setSuccessed(false);
            resultModel.setReturnValue(false);
            resultModel.setErrorDesc("typeCode不能为空");
            return resultModel;
        }
        return mediaCommonConfigFacadeIntegration.addPositionClassType(positionClassType);
    }

    /**
    * @Title: delPositionClassTypeById  
    * @Description:根据主键ID删除媒体配置信息
    * @param id
    * @param typeCode 标签码
    * @return ResultModel<Boolean> 
     */
    @LogBefore(operType = "/media/delById", keyName = "删除媒体配置信息")
    @RequestMapping(value = "/delById", method = RequestMethod.DELETE)
    public ResultModel<Boolean> delPositionClassTypeById(@RequestParam(value = "id") Long id,
            @RequestParam(value = "typeCode") String typeCode) {
        return mediaCommonConfigFacadeIntegration.delPositionClassTypeById(id, typeCode);
    }

}
