package com.bxm.adsmanager.web.controller.media;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.facade.model.position.PositionUpdateDto;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.adsmedia.media.NewMediaFacadeIntegration;
import com.bxm.adsmanager.integration.adsmedia.provider.ProviderFacadeIntegration;
import com.bxm.adsmanager.model.constant.RedisKeys;
import com.bxm.adsmanager.model.dao.common.Dictionaries;
import com.bxm.adsmanager.model.dao.media.AdMedia;
import com.bxm.adsmanager.model.dao.media.AdMediaPosition;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AvilableTicketSearchDto;
import com.bxm.adsmanager.model.dto.position.PositionDirectFlowAssignDto;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.model.vo.AdTicketAllVo;
import com.bxm.adsmanager.model.vo.media.AdMediaTagVo;
import com.bxm.adsmanager.model.vo.media.ProviderForAdsmanagerVO;
import com.bxm.adsmanager.service.common.DictionariesService;
import com.bxm.adsmanager.service.media.MediaService;
import com.bxm.adsmanager.service.mediamanager.PositionTicketWeightService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.utils.UserRoleCodeUtil;
import com.bxm.adsmanager.utils.WechatMiniAppVerifyFileUploadUtil;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.bxm.adsmedia.facade.model.media.MediaAuditVO;
import com.bxm.adsmedia.facade.model.provider.ProviderAppAdRO;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.bxm.warcar.cache.Updater;
import com.github.pagehelper.PageInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 媒体标签控制层
 *
 * @author 阿导
 * @version 1.0
 * @fileName com.bxm.adsmanager.web.controller.media.MediaController.java
 * @CopyRright (c) 2018-万物皆导
 * @created 2018-04-08 15:04:00
 */
@RestController
public class MediaController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(MediaController.class);

    /**
     * 业务层自动注入
     */
    @Autowired
    private MediaService mediaService;

    /**
     * 字典数据访问层注入
     */
    @Autowired
    private DictionariesService dictionariesService;

    @Autowired
    private PositionTicketWeightService positionTicketWeightService;

    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;

    @Autowired
    private NewMediaFacadeIntegration newMediaFacadeIntegration;

    @Autowired
    private ProviderFacadeIntegration providerFacadeIntegration;

    @Autowired
    @Qualifier("jedisUpdater")
    private Updater updater;

    @Autowired
    @Qualifier("jedisUpdaterForGateway")
    private Updater updaterForGateway;

    /**
     * 简单获取媒体信息
     * wuwenquan 20180621
     */
    @GetMapping(value = "/getMedia", produces = "application/json")
    public ResultModel<List<AdMedia>> queryMedia(@RequestParam(value = "keyword", required = false) String keyword) {
        // 声明结果
        ResultModel<List<AdMedia>> rs = new ResultModel<>();
        try {
            // 调用服务层
            rs.setReturnValue(mediaService.queryMedia2(keyword));
            rs.setSuccessed(true);
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        // 返回
        return rs;
    }


    /**
     * 获取媒体信息
     *
     * @param keyword  产品名称/appkey
     * @param mjcode   媒介CODE
     * @param bdcode   商务CODE
     * @param prepay   预付媒体
     * @param pageNum  页码
     * @param pageSize 页面大小
     * @return com.bxm.util.dto.ResultModel<com.github.pagehelper.PageInfo<com.bxm.adsmanager.model.dao.media.AdMedia>>
     * @author 阿导
     * @time 2018/4/9
     * @CopyRight 杭州微财科技有限公司
     */
    @GetMapping(value = "/media", produces = "application/json")
    public ResultModel<PageInfo<ProviderForAdsmanagerVO>> queryMedia(@RequestParam(value = "keyword", required = false) String keyword,
                                                                     @RequestParam(value = "mjcode", required = false) String mjcode,
                                                                     @RequestParam(value = "bdcode", required = false) String bdcode,
                                                                     @RequestParam(value = "email", required = false) String email,
                                                                     @RequestParam(value = "prepay", required = false) Integer prepay,
                                                                     @RequestParam(value = "areaType", required = false) Integer areaType,
                                                                     @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                     @RequestParam(value = "pageSize", required = false, defaultValue = "20") Integer pageSize,
                                                                     HttpServletRequest request, HttpServletResponse response) {
        User user = getUser(request, response);
        if (null == user) {
            throw new BusinessException("未登录！");
        }
        return ResultModelFactory.SUCCESS(mediaService.queryMedia(keyword, mjcode, bdcode, email, prepay, pageNum, pageSize, user,areaType));
    }

    /**
     * 上传微信小程序校验文件
     * 只能上传txt后缀的文件
     * @param request
     * @param response
     * @return
     */
    @LogBefore(operType="/media/uploadWechatMiniAppVerify",keyName="上传微信小程序校验文件")
    @RequestMapping(value = "/media/uploadWechatMiniAppVerify", method = RequestMethod.POST)
    public ResultModel uploadWechatMiniAppVerify(HttpServletRequest request, HttpServletResponse response) {
        ResultModel rs = new ResultModel();
        try {
            HashMap<String, String> map = WechatMiniAppVerifyFileUploadUtil.upload(request);

            //保存到redis中
            for (Map.Entry<String, String> entry : map.entrySet()) {
                updaterForGateway.hupdate(RedisKeys.getWechatMiniAppVerify(), entry.getKey(), entry.getValue());
            }

            rs.setSuccessed(true);
        }catch (Exception e){
            LOGGER.error("上传微信小程序校验文件出错"+e.getMessage(), e);
            return ResultModelFactory.FAIL500("上传微信小程序校验文件出错");
        }
        return rs;
    }

    /**
     * 查询广告位列表信息-分页
     * 媒体管理-广告位管理-广告位子链接-查询
     * @param appkey
     * @param putinType
     * @param pageNum
     * @param pageSize
     * @return com.bxm.util.dto.ResultModel<com.github.pagehelper.PageInfo<com.bxm.adsmanager.model.dao.media.AdMediaPosition>>
     * @author 阿导
     * @time 2018/4/9
     * @CopyRight 杭州微财科技有限公司
     */
    @GetMapping(value = "/media/position", produces = "application/json")
    public ResultModel<PageInfo<AdMediaPosition>> queryMediaPosition(@RequestParam(value = "appkey") String appkey,
                                                                     @RequestParam(value = "putinType", required = false) Byte putinType,
                                                                     @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                     @RequestParam(value = "pageSize", required = false, defaultValue = "20") Integer pageSize,
                                                                     @RequestParam(value = "keywords", required = false) String keywords) {
        return ResultModelFactory.SUCCESS(mediaService.queryMediaPosition(appkey, putinType, pageNum, pageSize, keywords));
    }


    /**
     * 获取广告位链接
     * @param positionId
     * @return
     * @author zhengwangeng
     */
    @GetMapping(value = "/media/position/getUrl", produces = "application/json")
    public ResultModel getPositionUrl(@RequestParam(value = "positionId") String positionId) {
        if (StringUtils.isBlank(positionId)) {
            throw new BusinessException("请先选择广告位");
        }
        return ResultModelFactory.SUCCESS(newAppEntranceFacadeIntegration.getUrl(positionId));
    }


    /**
     * 查询标签信息
     *
     * @param appkey
     * @param business
     * @return com.bxm.util.dto.ResultModel<java.util.List<com.bxm.adsmanager.model.dao.media.AdMediaTag>>
     * @author 阿导
     * @time 2018/4/9
     * @CopyRight 杭州微财科技有限公司
     */
    @GetMapping(value = "/media/position/tag", produces = "application/json")
    public ResultModel<List<AdMediaTagVo>> queryTagByPositionId(@RequestParam(value = "appkey") String appkey,
                                                                @RequestParam(value = "business") String business) {
        // 声明结果
        ResultModel<List<AdMediaTagVo>> rs = new ResultModel<>();
        try {
            // 调用服务层
            rs.setReturnValue(mediaService.queryTagByPositionId(appkey, business));
            rs.setSuccessed(true);
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        // 返回
        return rs;
    }

    /**
     * 查询可用广告券信息
     */
    @GetMapping(value = "/media/position/getAvailableTicket", produces = "application/json")
    public ResultModel<PageInfo<AdTicketAllVo>> getAvailableTicket(AvilableTicketSearchDto dto) {
        // 声明结果
        ResultModel rs = new ResultModel<>();
        try {
            // 调用服务层
            rs.setReturnValue(positionTicketWeightService.getAvailableTicket(dto));
            rs.setSuccessed(true);
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        // 返回
        return rs;
    }

    /**
     * 获取字典
     *
     * @param code
     * @return com.bxm.util.dto.ResultModel<java.util.List<com.bxm.adsmanager.model.dao.common.Dictionaries>>
     * @author 阿导
     * @time 2018/4/9
     * @CopyRight 杭州微财科技有限公司
     */
    @GetMapping(value = "/media/code", produces = "application/json")
    public ResultModel<List<Dictionaries>> queryDictionaries(@RequestParam(value = "code") String code) {
        // 声明结果
        ResultModel<List<Dictionaries>> rs = new ResultModel<>();

        try {
            // 调用服务层
            // 获取 标签 字典信息
            rs.setReturnValue(dictionariesService.findAll(code));
            rs.setSuccessed(true);
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        // 返回
        return rs;
    }

    /**
     * 删除标签
     *
     * @param appkey
     * @param businessArray
     * @param tagArray
     * @param isBatch       是否批量 2 不是批量，其他批量
     * @return com.bxm.util.dto.ResultModel<java.lang.Boolean>
     * @author 阿导
     * @time 2018/4/9
     * @CopyRight 杭州微财科技有限公司
     */
    @LogBefore(operType = "/media/tag/delete", keyName = "删除标签")
    @PostMapping(value = "/media/tag/delete", produces = "application/json")
    public ResultModel<Boolean> deleteTag(HttpServletRequest request, HttpServletResponse response,
                                          @RequestParam(value = "appkey") String appkey,
                                          @RequestParam(value = "businessArray") String businessArray,
                                          @RequestParam(value = "tagArray") String tagArray,
                                          @RequestParam(value = "oldRegionArray", required = false) String oldRegionArray,
                                          @RequestParam(value = "oldTimeArray", required = false) String oldTimeArray,
                                          @RequestParam(value = "isBatch", required = false) String isBatch) {
        // 声明结果
        ResultModel<Boolean> rs = new ResultModel<>();
        if (StringUtil.isEmpty(businessArray) || StringUtil.isEmpty(tagArray)) {
            rs.setReturnValue(false);
            rs.setSuccessed(false);
            rs.setErrorDesc("参数不正确");
        } else {
            try {
                // 调用服务层
                mediaService.deleteTag(appkey, businessArray, tagArray, oldRegionArray, oldTimeArray, isBatch);
                rs.setReturnValue(true);
                rs.setSuccessed(true);
            } catch (Exception e) {
                // 异常处理
                LOGGER.error(e.getMessage(), e);
                rs.setReturnValue(false);
                rs.setSuccessed(false);
                rs.setErrorDesc("system error");
            }
        }
        // 返回
        return rs;
    }

    /**
     * 批量新增标签地域时间段黑名单
     *
     * @param appkey
     * @param businessArray
     * @param tagArray
     * @param regionArray
     * @param timeArray
     * @return com.bxm.util.dto.ResultModel<java.lang.Boolean>
     * @author 阿导
     * @time 2018/4/9
     * @CopyRight 杭州微财科技有限公司
     */
    @LogBefore(operType = "/media/tag/add", keyName = "新增标签")
    @PostMapping(value = "/media/tag/add", produces = "application/json")
    public ResultModel<Boolean> batchAddTag(HttpServletRequest request, HttpServletResponse response,
                                            @RequestParam(value = "appkey") String appkey,
                                            @RequestParam(value = "businessArray") String businessArray,
                                            @RequestParam(value = "tagArray") String tagArray,
                                            @RequestParam(value = "regionArray", required = false) String regionArray,
                                            @RequestParam(value = "timeArray", required = false) String timeArray) {

        // 声明结果
        ResultModel<Boolean> rs = new ResultModel<>();

        try {
            // 调用服务层
            mediaService.bathInsertTag(appkey, businessArray, tagArray, regionArray, timeArray);
            rs.setReturnValue(true);
            rs.setSuccessed(true);
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setReturnValue(false);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }

        // 返回
        return rs;
    }
    @LogBefore(operType = "/media/tag/copy", keyName = "新增标签")
    @PostMapping(value = "/media/tag/copy", produces = "application/json")
    public ResultModel<Boolean> batchAddTag(HttpServletRequest request, HttpServletResponse response,
                                            @RequestParam(value = "positionIds") String positionIds,
                                            @RequestParam(value = "copyFromPositionId") String copyFromPositionId) {
        // 声明结果
        ResultModel<Boolean> rs = new ResultModel<>();

        try {
            // 调用服务层
            mediaService.bathInsertByCopy(copyFromPositionId,positionIds);
            rs.setReturnValue(true);
            rs.setSuccessed(true);
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setReturnValue(false);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }

        // 返回
        return rs;
    }

    /**
     * 更新标签
     *
     * @param appkey
     * @param business
     * @param oldTag
     * @param newTag
     * @param regionArray
     * @param timeArray
     * @return com.bxm.util.dto.ResultModel<java.lang.Boolean>
     * @author 阿导
     * @time 2018/4/9
     * @CopyRight 杭州微财科技有限公司
     */
    @LogBefore(operType = "/media/tag/update", keyName = "更新标签")
    @PostMapping(value = "/media/tag/update", produces = "application/json")
    public ResultModel<Boolean> updateTag(HttpServletRequest request, HttpServletResponse response,
                                          @RequestParam(value = "appkey") String appkey,
                                          @RequestParam(value = "business") String business,
                                          @RequestParam(value = "oldTag") String oldTag,
                                          @RequestParam(value = "oldRegionArray", required = false) String oldRegionArray,
                                          @RequestParam(value = "oldTimeArray", required = false) String oldTimeArray,
                                          @RequestParam(value = "newTag") String newTag,
                                          @RequestParam(value = "regionArray", required = false) String regionArray,
                                          @RequestParam(value = "timeArray", required = false) String timeArray) {

        // 声明结果
        ResultModel<Boolean> rs = new ResultModel<>();

        try {
            // 调用服务层
            mediaService.updateTag(appkey, business, oldTag, newTag, regionArray, timeArray, oldRegionArray, oldTimeArray);
            rs.setReturnValue(true);
            rs.setSuccessed(true);
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setReturnValue(false);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }

        // 返回
        return rs;
    }

    /**
     * 老数据同步到新数据
     *
     * @param
     * @return com.bxm.util.dto.ResultModel<java.lang.Boolean>
     * @author 阿导
     * @time 2018/4/11
     * @CopyRight 杭州微财科技有限公司
     */
    @LogBefore(operType = "/media/tag/oldtonew", keyName = "同步老系统标签限制")
    @GetMapping(value = "/media/tag/oldtonew", produces = "application/json")
    @Deprecated
    public ResultModel<Boolean> oldToNew(HttpServletRequest request, HttpServletResponse response) {
        // 声明结果
        ResultModel<Boolean> rs = new ResultModel<>();

        try {
            // 调用服务层
            mediaService.synchronizationTags();
            rs.setReturnValue(true);
            rs.setSuccessed(true);
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setReturnValue(false);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }

        // 返回
        return rs;
    }

    /**
     * 老数据同步到新数据
     *
     * @param
     * @return com.bxm.util.dto.ResultModel<java.lang.Boolean>
     * @author 拉拉
     * @time 2018/4/11
     * @CopyRight 杭州微财科技有限公司
     */
    @LogBefore(operType = "/media/tag/pusholdByPositionId", keyName = "同步广告位标签")
    @GetMapping(value = "/media/tag/pusholdByPositionId", produces = "application/json")
    @Deprecated
    public ResultModel<Boolean> pusholdByPositionId(HttpServletRequest request, HttpServletResponse response) {
        // 声明结果
        ResultModel<Boolean> rs = new ResultModel<>();

        try {
            // 调用服务层
            mediaService.pusholdByPositionId();
            rs.setReturnValue(true);
            rs.setSuccessed(true);
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setReturnValue(false);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }

        // 返回
        return rs;
    }

    /**
     * 同步广告券标签
     *
     * @param
     * @return com.bxm.util.dto.ResultModel<java.lang.Boolean>
     * @author 拉拉
     * @time 2018/4/11
     * @CopyRight 杭州微财科技有限公司
     */
    @LogBefore(operType = "/ticket/pushTagsByTicketId", keyName = "同步广告券标签")
    @GetMapping(value = "/ticket/pushTagsByTicketId", produces = "application/json")
    @Deprecated
    public ResultModel<Boolean> synchronizationPushTicketTags(HttpServletRequest request,
                                                              HttpServletResponse response) {
        // 声明结果
        ResultModel<Boolean> rs = new ResultModel<>();

        try {
            // 调用服务层
            mediaService.pushTagsByTicketId();
            rs.setReturnValue(true);
            rs.setSuccessed(true);
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setReturnValue(false);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }

        // 返回
        return rs;
    }

    /**
     * 回滚系统广告位标签
     *
     * @param
     * @return com.bxm.util.dto.ResultModel<java.lang.Boolean>
     * @author 拉拉
     * @time 2018/4/11
     * @CopyRight 杭州微财科技有限公司
     */
    @LogBefore(operType = "/tag/rollbackTagByPositionId", keyName = "回滚系统广告位标签")
    @GetMapping(value = "/tag/rollbackTagByPositionId", produces = "application/json")
    @Deprecated
    public ResultModel<Boolean> pushOld(HttpServletRequest request, HttpServletResponse response) {
        // 声明结果
        ResultModel<Boolean> rs = new ResultModel<>();

        try {
            // 调用服务层
            mediaService.rollbackTagByPositionId();
            rs.setReturnValue(true);
            rs.setSuccessed(true);
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setReturnValue(false);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }

        // 返回
        return rs;
    }

    /**
     * 回滚系统广告位标签
     *
     * @param
     * @return com.bxm.util.dto.ResultModel<java.lang.Boolean>
     * @author 拉拉
     * @time 2018/4/11
     * @CopyRight 杭州微财科技有限公司
     */
    @LogBefore(operType = "/tag/comparison", keyName = "比对广告位标签")
    @GetMapping(value = "/tag/comparison", produces = "application/json")
    @Deprecated
    public ResultModel<Boolean> comparison(HttpServletRequest request, HttpServletResponse response) {
        // 声明结果
        ResultModel<Boolean> rs = new ResultModel<>();

        try {
            // 调用服务层
            mediaService.comparison();
            rs.setReturnValue(true);
            rs.setSuccessed(true);
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setReturnValue(false);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }

        // 返回
        return rs;
    }

    /**
     * 修改开发者信息接口， app别名，媒介，商务，是否为预付媒体
     * @param request
     * @param response
     * @return
     */
    @LogBefore(operType = "/media/update", keyName = "广告")
    @RequestMapping(value = "/media/update", method = RequestMethod.POST)
    public ResultModel<Boolean> positionUpdate(@Validated PositionUpdateDto positionUpdateDto,
                                               HttpServletRequest request,
                                               HttpServletResponse response) {
        Boolean prepay = positionUpdateDto.getPrepay();
        String appKey = positionUpdateDto.getAppKey();

        User user = getUser(request, response);
        ProviderAppAdRO providerAppInfo = providerFacadeIntegration.getProviderAppInfoByAppKey(positionUpdateDto.getAppKey());
        Short advanceType = providerAppInfo.getAdvanceType();
        Boolean isUpdatePrePay = advanceType != null  && ( (prepay && advanceType == 0) || (!prepay && advanceType == 1));
        // 只有运营经理有权限修改预付类型
        if (isUpdatePrePay) {
            if (UserRoleCodeUtil.isNotMJLeader(user)) {
               return ResultModelFactory.FAIL500("仅媒介经理权限可以修改预付类型");
            }
        }
        positionUpdateDto.setModifier(user.getUsername());
        Boolean aBoolean = mediaService.updateProvider(positionUpdateDto);

        // 如果修改了预付类型 置空所有广告位合作类型
        if (isUpdatePrePay) {
            newAppEntranceFacadeIntegration.updateCooperationTypeByAppKey(appKey);
        }
        return ResultModelFactory.SUCCESS(aBoolean);
    }

    /**
     * 批量新增标签地域时间段黑名单
     *
     * @param tagArray 传递过来是一个json字符串
     * @return com.bxm.util.dto.ResultModel<java.lang.Boolean>
     * @author 拉拉
     * @time 2018/11/23
     * @CopyRight 杭州微财科技有限公司
     */
    @LogBefore(operType = "/media/tag/insertAllPositionTag", keyName = "新增所有黑名单标签")
    @PostMapping(value = "/media/tag/insertAllPositionTag", produces = "application/json")
    public ResultModel<Boolean> insertAllPositionTage(HttpServletRequest request, HttpServletResponse response,
                                                      @RequestParam(value = "tagArray") String tagArray) {

        // 声明结果
        ResultModel<Boolean> rs = new ResultModel<>();
        try {
            // 调用服务层
            List<AppEntranceAdRO> appRo = newAppEntranceFacadeIntegration.getAllList(new QueryAppEntranceParamDTO());
            System.out.println("总共有这么多广告位：" + appRo.size());
            if (CollectionUtils.isNotEmpty(appRo)) {

                Map<String, List<String>> map = new HashMap<>();
                //这个循环是将子链接广告位按照 开发者 区分 放在map里面
                for (AppEntranceAdRO ar : appRo) {
                    //存放广告位
                    List<String> maList = new ArrayList<>();
                    //说明之前没有存放map里面
                    if (map.get(ar.getAppKey()) == null) {
                        maList.add(ar.getAppEntranceId().toString());
                    } else {
                        //说明之前存放说数据,先取出来，然后在加上本次的数据
                        maList = map.get(ar.getAppKey());
                        maList.add(ar.getAppEntranceId().toString());
                    }
                    map.put(ar.getAppKey(), maList);
                }
                System.out.println("总共这么多开发者：" + map.size());
                //开始循环开发者，每个开发者调用一次
                for (String appKey : map.keySet()) {
                    //这个是所有的广告位
                    List<String> maString = map.get(appKey);
                    //  System.out.println("开发者appKey："+appKey+":有"+maString.size()+"个广告位");
                    if (maString.size() > 0) {
                        //参数按照顺序是 appkey,广告位集合，标签结合，地区集合，时间集合
                        //按照每个开发者一个推送完成 
                        mediaService.bathInsertTag(appKey, com.alibaba.fastjson.JSON.toJSONString(maString), tagArray, null, null);
                    }
                }

                System.out.println("推送完毕");
            }
            rs.setReturnValue(true);
            rs.setSuccessed(true);
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setReturnValue(false);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }

        // 返回
        return rs;
    }
    
    /**
     * @description 根据广告位ID查询券的分类标签
     * @param positionId
     * @return com.bxm.util.dto.ResultModel<java.util.List<java.lang.String>>
     */
    @GetMapping(value = "/media/tag/positionId", produces = "application/json")
    public ResultModel<List<String>> queryTagsByPositionId(@RequestParam(value = "positionId") String positionId) {
        ResultModel<List<String>> rs = new ResultModel<>();
        try {
            rs.setReturnValue(mediaService.queryTagsByPositionId(positionId));
        } catch (Exception e) {
            LOGGER.error("查询分类标签出错"+ e.getMessage(), e);
            rs.setSuccessed(false);
            return rs;
        }
        return rs;
    }



    /**
     * Description: 运营后台查询审核页面的 媒体列表
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/28 15:38
     *
     * @param companyName 公司名称
     * @param mediaName   媒体名称
     * @param status      状态 0待审核， 1审核通过， 2审核拒绝
     * @param pageNum     页码
     * @param pageSize    页面大小
     * @return com.bxm.util.dto.ResultModel<com.github.pagehelper.PageInfo<com.bxm.adsmedia.facade.model.media.MediaAuditVO>>
     * @author hxpeng
     */
    @RequestMapping(value = "/media/getAuditPage", method = RequestMethod.GET)
    public ResultModel<PageInfo<MediaAuditVO>> getAuditPage(@RequestParam(name = "companyName", required = false) String companyName,
                                                            @RequestParam(name = "mediaName") String mediaName,
                                                            @RequestParam(name = "status") Byte status,
                                                            @RequestParam(name = "providerId",required = false,defaultValue = "-1") Long providerId,
                                                            @RequestParam(name = "mjCode", required = false) String mjCode,
                                                            @RequestParam(name = "areaType", required = false) Integer areaType,
                                                            @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
                                                            @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize,
                                                            HttpServletRequest request,
                                                            HttpServletResponse response) {
        User user = getUser(request, response);
        if (user.getRoleCodes()==null){
            user.setRoleCodes(Collections.EMPTY_LIST);
        }
        //媒介经理和风控可以看到所有的
        Boolean look_all = user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode()) || user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode()) ;
        if(look_all == false){
            mjCode = user.getUsername();
        }
        return ResultModelFactory.SUCCESS(mediaService.getAuditPage(companyName, mediaName, mjCode, status,providerId,areaType, pageNum, pageSize));
    }

    /**
     * Description: 审核媒体
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/25 15:43
     *
     * @param id           媒体id
     * @param auditPass    审核通过
     * @param refuseReason 拒绝原因
     * @param reviewRefuseIds 拒绝原因ID列表
     * @return com.bxm.util.dto.ResultModel<java.util.List<java.lang.String>>
     * @author hxpeng
     */
    @LogBefore(operType = "/media/audit", keyName = "审核媒体")
    @RequestMapping(value = "/media/audit", method = RequestMethod.POST)
    public ResultModel<Boolean> audit(@RequestParam("id") Long id,
                                      @RequestParam("auditPass") Boolean auditPass,
                                      @RequestParam(name = " ", required = false) String refuseReason,
                                      @RequestParam(name = "reviewRefuseIds", required = false) String reviewRefuseIds,
                                      HttpServletRequest request,
                                      HttpServletResponse response) {
        User user = getUser(request, response);
        if(user.getRoleCodes()==null){
            user.setRoleCodes(Collections.EMPTY_LIST);
        }
        Boolean isMJ = user.getRoleCodes().contains(RoleEnum.MJ.getCode()) || user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode());
        Boolean fk = user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode());
        if(!isMJ && !fk){
            ResultModel<Boolean> rs = new ResultModel<>();
            String desc = "只有媒介/媒介经理/风控角色可以操作审核！";
            LOGGER.error(desc);
            rs.setSuccessed(false);
            rs.setErrorDesc(desc);
            return rs;
        }
        //媒介/媒介经理是初审，否则就是终审（风控）
        Boolean audit = newMediaFacadeIntegration.audit(id, auditPass, isMJ, refuseReason, reviewRefuseIds, user.getUsername());

        //20210325-风控优化 http://47.110.160.70:8090/pages/viewpage.action?pageId=25993887
        if (auditPass && isMJ) {
            isMJ = false; //不是媒介那就是风控
            audit = newMediaFacadeIntegration.audit(id, auditPass, isMJ, refuseReason, reviewRefuseIds, user.getUsername());
        }
        return ResultModelFactory.SUCCESS(audit);
    }


    /**
     * Description: 修改媒体标签
     * JDK version used:<JDK1.8>
     * Create Date：2019/7/12 9:53
     *
     * @param id           媒体id
     * @param tags 标签
     * @return com.bxm.util.dto.ResultModel<java.lang.Boolean>
     * @author zhengwangeng
     */
    @LogBefore(operType = "/media/updateTags", keyName = "修改媒体标签")
    @RequestMapping(value = "/media/updateTags", method = RequestMethod.POST)
    public ResultModel<Boolean> updateTags(@RequestParam("id") Long id,
                                      @RequestParam("tags") String tags,
                                      HttpServletRequest request,
                                      HttpServletResponse response) {
        return ResultModelFactory.SUCCESS(newMediaFacadeIntegration.updateTags(id, tags, getUser(request, response).getUsername()));
    }


    /**
     * 开启或关闭广告位严格屏蔽
     * @param positionId 广告位Id
     * @param highestPositionStatus 严格屏蔽开关动作 true开启,false关闭
     * @return com.bxm.util.dto.ResultModel
     * @author tangx
     * @DATE 2019/8/15 17:22
     */
    @RequestMapping(value = "/media/updateHighestPositions", method = RequestMethod.POST)
    public ResultModel updateHighestPositions(@RequestParam(value = "positionId") String positionId,
                                              @RequestParam(value = "highestPositionStatus") Boolean highestPositionStatus) {

        if (StringUtils.isBlank(positionId) || highestPositionStatus == null) {
            return ResultModelFactory.FAIL400("广告位不能为null");
        }
        try {
            mediaService.updateHighestPositions(positionId, highestPositionStatus);
            return ResultModelFactory.SUCCESS("OK");
        } catch (Exception e) {
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }

    /** 广告位设置直投券流量分配
     * @param  positionId 广告位id
     * @param directTicketRatio  直投券比例
     * @return
     */
    @RequestMapping(value = "/media/position/directWithTicket/ratio", method = RequestMethod.POST)
    public ResultModel setPositionDirectFlow(HttpServletRequest servletRequest,
                                             HttpServletResponse servletResponse,
                                             @RequestParam(value = "positionId") String positionId,
                                             @RequestParam(value = "directTicketRatio") Integer directTicketRatio){
        if (StringUtils.isBlank(positionId)){
            throw new BusinessException("请先选择广告位");
        }
        if (directTicketRatio==null
                ||directTicketRatio<0
                ||directTicketRatio>100){
            throw new BusinessException("比例大小设置有误");
        }

        PositionDirectFlowAssignDto positionDirectFlowAssignDto=new PositionDirectFlowAssignDto();
        positionDirectFlowAssignDto.setPositionId(positionId);
        positionDirectFlowAssignDto.setDirectTicketRatio(directTicketRatio);
         //检查权限 仅对媒介经理开启
        User user = getUser(servletRequest, servletResponse);
        if(user.getRoleCodes()==null){
            user.setRoleCodes(Collections.EMPTY_LIST);
        }
        boolean isMjLeader = user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode());
        if (!isMjLeader){
            throw new BusinessException("仅对媒介经理开放");
        }
        //检查对应的广告位是否存在直投全
        boolean haveDirecter = mediaService.setPositionDirectFlow(positionDirectFlowAssignDto);
        if (haveDirecter){
            return ResultModelFactory.SUCCESS("OK");
        }
        return ResultModelFactory.FAIL400("该广告位无直投券,无法分配直投券流量");
    }

}