package com.bxm.adsmanager.web.controller.media;

import com.bxm.adsmanager.model.dto.mediamanager.MediaPositionBlackAppIdDto;
import com.bxm.adsmanager.model.dto.mediamanager.MediaPositionBlackAppIdSearchDto;
import com.bxm.adsmanager.service.media.MediaPositionBlackAppIdService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

/**
 * 广告位appId黑名单配置
 * @author : tangxiao
 */
@RestController
@RequestMapping("/mediaPositionBlackAppId")
@Slf4j
public class MediaPositionBlackAppIdController extends BaseController {

    @Autowired
    private MediaPositionBlackAppIdService mediaPositionBlackAppIdService;

    private static final ReentrantLock dataLock = new ReentrantLock();

    @LogBefore(operType = "/mediaPositionBlackAppId/save", keyName = "广告位AppId黑名单添加")
    @RequestMapping("/save")
    public ResultModel savePositionBlackAppId(@Validated(MediaPositionBlackAppIdDto.Add.class) MediaPositionBlackAppIdDto dto) throws Exception{
        boolean tryLock = dataLock.tryLock(5, TimeUnit.SECONDS);
        try {
            if (!tryLock) {
                return ResultModelFactory.FAIL500("请求繁忙，请稍后再试");
            }
            List<String> list = mediaPositionBlackAppIdService.savePositionBlackAppId(dto);
            return ResultModelFactory.SUCCESS(StringUtils.join(list,","));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return ResultModelFactory.FAIL500("系统异常");
        } finally {
            if (tryLock) {
                dataLock.unlock();
            }
        }
    }

    @RequestMapping("/update")
    @LogBefore(operType = "/mediaPositionBlackAppId/update", keyName = "广告位AppId黑名单更新")
    public ResultModel updatePositionBlackAppId(@Validated(MediaPositionBlackAppIdDto.Update.class)  MediaPositionBlackAppIdDto dto) {
        mediaPositionBlackAppIdService.updatePositionBlackAppId(dto);
        return ResultModelFactory.SUCCESS();
    }

    @RequestMapping("/list")
    public ResultModel list(MediaPositionBlackAppIdSearchDto dto) {
        return ResultModelFactory.SUCCESS(mediaPositionBlackAppIdService.list(dto));
    }


    @RequestMapping("/delete")
    @LogBefore(operType = "/mediaPositionBlackAppId/delete", keyName = "广告位AppId黑名单删除")
    public ResultModel delete(@RequestParam("ids") String ids) throws Exception{
        if (StringUtils.isBlank(ids)) {
            return ResultModelFactory.FAIL400("缺少参数：ids");
        }
        boolean tryLock = dataLock.tryLock(5, TimeUnit.SECONDS);
        try {
            if (!tryLock) {
                return ResultModelFactory.FAIL500("请求繁忙，请稍后再试");
            }
            mediaPositionBlackAppIdService.delete(ids);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return ResultModelFactory.FAIL500("系统异常");
        } finally {
            if (tryLock) {
                dataLock.unlock();
            }
        }
        return ResultModelFactory.SUCCESS();
    }

}
