package com.bxm.adsmanager.web.controller.media;

import com.bxm.adsmanager.service.media.MediaPositionDirectTicketService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Created by wuwenquan on 2018/10/8.
 */
@RestController
@RequestMapping("/mediaPositionDirectTicket")
public class MediaPositionDirectTicketController extends BaseController{

   private static final Logger LOGGER = LoggerFactory.getLogger(MediaPositionWhiteTicketController.class);

   @Autowired
   private MediaPositionDirectTicketService mediaPositionDirectTicketService;

   @RequestMapping(value = "/batchSaveorUpdate", method = RequestMethod.POST, produces = "application/json")
   public ResultModel batchSaveorUpdate(HttpServletRequest request, HttpServletResponse response,
                                        @RequestParam(value = "positionIdAndSizes", required = true) String positionIdAndSizes,
                                        @RequestParam(value = "ticketIds", required = false) String ticketIds){
      try {
         // 获取后台用户名
         String userName = getUser(request, response).getUsername();
         mediaPositionDirectTicketService.batchSaveorUpdate(positionIdAndSizes,ticketIds,userName);
         return ResultModelFactory.SUCCESS(null);
      } catch (Exception e) {
         LOGGER.error("配置直投广告券出错" + e.getMessage(), e);
         return ResultModelFactory.FAIL500(e.getMessage());
      }

   }
}
