package com.bxm.adsmanager.web.controller.media;

import java.util.Collections;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.integration.exception.PushProdException;
import com.bxm.adsmanager.model.dto.mediamanager.MediaPositionWhiteTicketDto;
import com.bxm.adsmanager.service.media.MediaPositionWhiteTicketService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;

/**
 * @author 拉拉
 * @version v1.1.4_Ticket
 * @fileName com.bxm.adsmanager.web.controller.adticketpopup.AdPopup.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2018-03-01 11:48:00
 * @modifier 拉拉
 * @updated 2018-03-01 11:48:00
 */
@RestController
@RequestMapping("/mediaPositionWhiteTicket")
public class MediaPositionWhiteTicketController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(MediaPositionWhiteTicketController.class);

    @Autowired
    private MediaPositionWhiteTicketService mediaPositionWhiteTicketService;

    /**
     * @param request
     * @param response
     * @param mediaPositionWhiteTicketDto
     * @return com.bxm.util.dto.ResultModel
     * @description 单个/批量添加，修改白名单
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     */
    @LogBefore(operType = "/mediaPositionWhiteTicket/batchSaveorUpdate", keyName = "广告位白名单广告券添加")
    @RequestMapping(value = "/batchSaveorUpdate", method = RequestMethod.POST, produces = "application/json")
    public ResultModel batchAdd(HttpServletRequest request, HttpServletResponse response,
                                MediaPositionWhiteTicketDto mediaPositionWhiteTicketDto) throws Exception {
        try {
            // 参数校验
            if (BeanValidator.validateGroup(mediaPositionWhiteTicketDto, MediaPositionWhiteTicketDto.Add.class) != null) {
                return ResultModelFactory.FAIL400(BeanValidator.validateGroup(mediaPositionWhiteTicketDto,
                        MediaPositionWhiteTicketDto.Add.class).getMessage());
            }
            // 获取后台用户名
            String userName = getUser(request, response).getUsername();
            mediaPositionWhiteTicketService.batchSaveorUpdate(mediaPositionWhiteTicketDto, userName);
            return ResultModelFactory.SUCCESS(null);
        } catch (PushProdException p) {
            LOGGER.error("添加广告位白名单广告券出错" + p.getMessage(), p);
            return ResultModelFactory.FAIL500("添加广告位白名单广告券出错");
        } catch (Exception e) {
            LOGGER.error("添加广告位白名单广告券出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }


    /*
     * @description 手动输入白名单
     * @param [request, response, mediaPositionWhiteTicketDto]
     * @return com.bxm.util.dto.ResultModel
     * @date 2019/2/19 0:29
     */
    @LogBefore(operType = "/mediaPositionWhiteTicket/savePositionWhiteTicket", keyName = "广告位白名单广告券添加")
    @RequestMapping(value = "/savePositionWhiteTicket", method = RequestMethod.POST, produces = "application/json")
    public ResultModel savePositionWhiteTicket(HttpServletRequest request, HttpServletResponse response, MediaPositionWhiteTicketDto mediaPositionWhiteTicketDto)
             throws Exception{
        ResultModel<List<Long>> rs = new ResultModel<>();
        try {
            if (StringUtils.isBlank(mediaPositionWhiteTicketDto.getTicketId())) {
                return ResultModelFactory.FAIL400("请输入白名单券");
            }
            String userName = getUser(request, response).getUsername();
            List<Long> ticketList = mediaPositionWhiteTicketService.savePositionWhiteTicket(mediaPositionWhiteTicketDto, userName);
            if (CollectionUtils.isNotEmpty(ticketList)) {
                Collections.sort(ticketList);
                rs.setReturnValue(ticketList);
                rs.setErrorDesc("存在无效的白名单券");
                return rs;
            }
        } catch (Exception e) {
            LOGGER.error("添加广告位白名单广告券出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
        return rs;
    }

}
