package com.bxm.adsmanager.web.controller.media;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.rtb.RtbCvrControl;
import com.bxm.adsmanager.model.dao.rtb.RtbRatioControl;
import com.bxm.adsmanager.model.dao.rtb.RtbSpeedControl;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.CvrStatisticDto;
import com.bxm.adsmanager.model.vo.AdTicketValueVo;
import com.bxm.adsmanager.model.dto.rtb.PositionRtbDto;
import com.bxm.adsmanager.model.vo.CvrStatisticVo;
import com.bxm.adsmanager.model.vo.rtb.PositionRtbVo;
import com.bxm.adsmanager.service.rtb.PositionRTBService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 媒体RTB配置
 */
@RestController
public class MediaRTBController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(MediaRTBController.class);


    @Autowired
    PositionRTBService positionRTBService;

    @RequestMapping(value = "/position/getPositionrtb", method = RequestMethod.GET)
    public ResultModel<PositionRtbVo> getPositionrtb(@RequestParam(value = "positionId") String positionId) {

        ResultModel<PositionRtbVo> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(positionRTBService.getPositionRtbByPositionId(positionId));
            resultModel.setSuccessed(true);
        } catch (Exception e) {
            LOGGER.error("查找广告位rtb列表出错", e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查找广告位rtb列表出错");
        }
        return resultModel;
    }


    @LogBefore(operType = "/position/setPositionrtb", keyName = "修改rtb配置")
    @RequestMapping(value = "/position/setPositionrtb")
    public ResultModel setPositionrtb(HttpServletRequest request, HttpServletResponse response,
                                      PositionRtbDto positionRtbDto) {
        checkPositionRtb(positionRtbDto);

        ResultModel resultModel = new ResultModel<>();
        try {
            User user = getUser(request, response);
            positionRTBService.saveOrUpdate(positionRtbDto, user);
            resultModel.setReturnValue(true);
            resultModel.setSuccessed(true);
        } catch (Exception e) {
            LOGGER.error("新增广告位rtb列表出错", e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("新增广告位rtb列表出错");
        }
        return resultModel;
    }

    private void checkPositionRtb(PositionRtbDto positionRtbDto) {
        if (StringUtils.isBlank(positionRtbDto.getPositionIds()) ||
                StringUtils.isBlank(positionRtbDto.getHeadTicketJson())) {
            throw new BusinessException("参数不能为空");
        }

//        String cvrControlJson = positionRtbDto.getCvrControlJson();
//        if (StringUtils.isNotBlank(cvrControlJson)) {
//            List<RtbCvrControl> rtbCvrControls = JSONObject.parseArray(cvrControlJson, RtbCvrControl.class);
//            for (RtbCvrControl rtbCvrControl : rtbCvrControls) {
//                Preconditions.checkArgument(
//                        Objects.nonNull(rtbCvrControl.getCvr())
//                                && rtbCvrControl.getCvr() >0d, "参数cvr不正确");
//                Preconditions.checkArgument(StringUtils.isNotBlank(rtbCvrControl.getStartTime()), "参数startTime不能为空");
//                Preconditions.checkArgument(StringUtils.isNotBlank(rtbCvrControl.getEndTime()), "参数endTime不能为空");
//                Preconditions.checkArgument(Objects.nonNull(rtbCvrControl.getEnable()), "参数enable不能为空");
//            }
//        }

        String ratioControlJson = positionRtbDto.getRatioControlJson();
        if (StringUtils.isNotBlank(ratioControlJson)) {
            List<RtbRatioControl> rtbRatioControls = JSONObject.parseArray(ratioControlJson, RtbRatioControl.class);
            for (RtbRatioControl rtbRatioControl : rtbRatioControls) {
                if (Objects.nonNull(rtbRatioControl.getCvr())) {
                    Preconditions.checkArgument(StringUtils.isNotBlank(rtbRatioControl.getAdGroupId()), "参数adgroupId不能为空");
                }
                if (Objects.isNull(rtbRatioControl.getCost()) && Objects.isNull(rtbRatioControl.getCvr())) {
                    Preconditions.checkArgument(
                            Objects.nonNull(rtbRatioControl.getShallowRatio()) || Objects.nonNull(rtbRatioControl.getDeepRatio()), "参数shallowRatio或deepRatio不能为空");
                }
                Preconditions.checkArgument(StringUtils.isNotBlank(rtbRatioControl.getStartTime()), "参数startTime不能为空");
                Preconditions.checkArgument(StringUtils.isNotBlank(rtbRatioControl.getEndTime()), "参数endTime不能为空");
                Preconditions.checkArgument(Objects.nonNull(rtbRatioControl.getEnable()), "参数enable不能为空");
            }
        }

        String ticketControlJson = positionRtbDto.getTicketControlJson();
        if (StringUtils.isNotBlank(ticketControlJson)) {
            List<RtbSpeedControl> ticketControls = JSONObject.parseArray(ticketControlJson, RtbSpeedControl.class);
            for (RtbSpeedControl ticketControl : ticketControls) {
                Preconditions.checkArgument(StringUtils.isNotBlank(ticketControl.getStartTime()), "参数startTime不能为空");
                Preconditions.checkArgument(StringUtils.isNotBlank(ticketControl.getEndTime()), "参数endTime不能为空");
                Preconditions.checkArgument(Objects.nonNull(ticketControl.getEnable()), "参数enable不能为空");
                Preconditions.checkArgument(Objects.nonNull(ticketControl.getCount()) && ticketControl.getCount() > 0, "参数count不正确");
                Preconditions.checkArgument(StringUtils.isNotBlank(ticketControl.getAdTicketId()), "参数adTicketId不能为空");

            }
        }

        String activityControlJson = positionRtbDto.getActivityControlJson();
        if (StringUtils.isNotBlank(activityControlJson)) {
            List<RtbSpeedControl> activityControls = JSONObject.parseArray(activityControlJson, RtbSpeedControl.class);
            for (RtbSpeedControl activityControl : activityControls) {
                Preconditions.checkArgument(StringUtils.isNotBlank(activityControl.getStartTime()), "参数startTime不能为空");
                Preconditions.checkArgument(StringUtils.isNotBlank(activityControl.getEndTime()), "参数endTime不能为空");
                Preconditions.checkArgument(Objects.nonNull(activityControl.getEnable()), "参数enable不能为空");
                Preconditions.checkArgument(Objects.nonNull(activityControl.getCount()) && activityControl.getCount() > 0, "参数count不正确");
                Preconditions.checkArgument(StringUtils.isBlank(activityControl.getAdTicketId()), "活动配置中参数adTicketId不能有值");
            }
        }

    }

    @RequestMapping(value = "/position/getNewPositionIds",method = RequestMethod.GET)
    public ResultModel getNewPositionIds(@RequestParam(name = "positionIds") String positionIds) {
        List<String> list =new ArrayList<>();
        try {
            list = positionRTBService.getNewPositionIds(positionIds);
        } catch (Exception e) {
            LOGGER.error("查找是否新rtb广告位信息出错"+ e.getMessage(), e);
            return ResultModelFactory.FAIL500("查找是否新rtb广告位信息出错");
        }
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue(list);
        return resultModel;
    }

    @RequestMapping(value = "/position/getTicketByIds",method = RequestMethod.GET)
    public ResultModel getTicketByIds(@RequestParam(name = "ticketIds") String ticketIds) {
        List<AdTicketValueVo> list =new ArrayList<>();
        try {
            list = positionRTBService.getTicketByIds(ticketIds);
        } catch (Exception e) {
            LOGGER.error("查找广告券信息出错"+ e.getMessage(), e);
            return ResultModelFactory.FAIL500("查找广告券信息出错");
        }
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue(list);
        return resultModel;
    }

    @RequestMapping(value = "/position/getCvrStatistic",method = RequestMethod.GET)
    public ResultModel getCvrStatistic(CvrStatisticDto cvrStatisticDto) {
        List<CvrStatisticVo> cvrStatistic = positionRTBService.getCvrStatistic(cvrStatisticDto);
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue(cvrStatistic);
        return resultModel;

    }

    @Data
    static  class test {
        String ticketIds;
        Integer targetOneBxm;
        Integer targetTwoBxm;
    }

}
