package com.bxm.adsmanager.web.controller.media;

import com.bxm.adsmanager.model.dto.mediamanager.MediaTestDto;
import com.bxm.adsmanager.model.vo.media.AdMediaTestVo;
import com.bxm.adsmanager.model.vo.media.MediaTicketVo;
import com.bxm.adsmanager.service.media.MediaTestService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @author 拉拉
 * @version v1.1.4_Ticket
 * @fileName com.bxm.adsmanager.web.controller.adticketpopup.AdPopup.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2018-03-01 11:48:00
 * @modifier 拉拉
 * @updated 2018-03-01 11:48:00
 */
@RestController
@RequestMapping("/mediaTest")
public class MediaTestController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTestController.class);

    @Autowired
    private MediaTestService mediaTestService;
    
    /**
     * @description
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param request
     * @param response
     * @param mediaTestDto
     * @return com.bxm.util.dto.ResultModel
     */
    @LogBefore(operType = "/mediaTest/add", keyName = "媒体测试添加")
    @RequestMapping(value = "/add", method = RequestMethod.POST, produces = "application/json")
    public ResultModel add(HttpServletRequest request, HttpServletResponse response,
                           MediaTestDto mediaTestDto) {
        try {
            // 参数校验
            if (BeanValidator.validateGroup(mediaTestDto, MediaTestDto.Add.class) != null) {
                return ResultModelFactory.FAIL400(BeanValidator.validateGroup(mediaTestDto,
                                                                              MediaTestDto.Add.class).getMessage());
            }
            // 获取后台用户名
            String userName = getUser(request, response).getUsername();
            mediaTestService.add(mediaTestDto, userName);
            return ResultModelFactory.SUCCESS(null);
        } catch (Exception e) {
            LOGGER.error("添加媒体测试出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }
    /**
     * @description
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param request
     * @param response 
     * @return com.bxm.util.dto.ResultModel
     */ 
    @RequestMapping(value = "/findAll", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<PageInfo<AdMediaTestVo>> findAll(HttpServletRequest request, HttpServletResponse response,
                                                        @RequestParam(value = "pageNum",required = false,defaultValue = "1") Integer pageNum,
                                                        @RequestParam(value = "pageSize",required = false,defaultValue = "20") Integer pageSize,
                                                        @RequestParam(value = "appKey",required = false ) String appKey  ,
                                                        @RequestParam(value = "keywords",required = false  ) String keywords,
                                                        @RequestParam(value = "mjCode",required = false  ) String mjCode) {
        try {
            ResultModel<PageInfo<AdMediaTestVo>> rs = new ResultModel<PageInfo<AdMediaTestVo>>();
            PageInfo<AdMediaTestVo> result = mediaTestService.findAllByAppKyeOrKeywords(appKey,keywords,mjCode,pageNum,pageSize);
            if (result != null) {
                rs.setReturnValue(result);
            }
            return rs;
        } catch (Exception e) {
            LOGGER.error("查找媒体测试广告位列表出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("查找媒体测试广告位列表出错");
        }
    }
    /**
     * @description
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param request
     * @param response 
     * @return com.bxm.util.dto.ResultModel
     */ 
    @RequestMapping(value = "/findAdMediaTestById", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<AdMediaTestVo> findAdMediaTestVoById(HttpServletRequest request, HttpServletResponse response,
                                               Long id) {
        ResultModel<AdMediaTestVo> rs = new ResultModel<AdMediaTestVo>();
        try {
            if(id==null) {
              return ResultModelFactory.FAIL400("广告券id不能为空");
            }
           
            AdMediaTestVo result = mediaTestService.findAdMediaTestVoById(id);
            if (result != null) {
                rs.setReturnValue(result);
            }
        } catch (Exception e) {
            LOGGER.error("加载媒体测试广告券列表出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
        return rs;
    }
    /**
     * @description
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param request
     * @param response 
     * @return com.bxm.util.dto.ResultModel
     */ 
    @RequestMapping(value = "/findTicketByParam", method = RequestMethod.POST, produces = "application/json")
    public ResultModel<PageInfo<MediaTicketVo>> findTicketByParam(HttpServletRequest request, HttpServletResponse response,
                                                                  @RequestParam(value = "pageNum",required = false,defaultValue = "1") Integer pageNum,
                                                                  @RequestParam(value = "pageSize",required = false,defaultValue = "20") Integer pageSize,
                                                                  @RequestParam(value = "keywords",required = false  ) String keywords,
                                                                  @RequestParam(value = "ids",required = false  ) String ids) {
        ResultModel<PageInfo<MediaTicketVo>> rs = new ResultModel<PageInfo<MediaTicketVo>>();
        try {
     
            PageInfo<MediaTicketVo> result = mediaTestService.findTicketByParam(keywords,pageNum,pageSize,ids);
            if (result != null) {
                rs.setReturnValue(result);
            }
        } catch (Exception e) {
            LOGGER.error("媒体测试查找广告券列表出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
        return rs;
    }
    /**
     * @description
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param request
     * @param response 
     * @return com.bxm.util.dto.ResultModel
     */ 
    @RequestMapping(value = "/findTicketByParamAndIds", method = RequestMethod.POST, produces = "application/json")
    public ResultModel<PageInfo<MediaTicketVo>> findTicketByParamAndIds(HttpServletRequest request, HttpServletResponse response,
                                                                  @RequestParam(value = "pageNum",required = false,defaultValue = "1") Integer pageNum,
                                                                  @RequestParam(value = "pageSize",required = false,defaultValue = "20") Integer pageSize,
                                                                  @RequestParam(value = "keywords",required = false  ) String keywords,
                                                                  @RequestParam(value = "ids",required = false  ) String ids) {
        ResultModel<PageInfo<MediaTicketVo>> rs = new ResultModel<PageInfo<MediaTicketVo>>();
        try {
     
            PageInfo<MediaTicketVo> result = mediaTestService.findTicketByParamAndIds(keywords,pageNum,pageSize,ids);
            if (result != null) {
                rs.setReturnValue(result);
            }
        } catch (Exception e) {
            LOGGER.error("查找媒体测试广告券列表出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
        return rs;
    }
    /**
     * @description
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param request
     * @param response
     * @param mediaTestDto
     * @return com.bxm.util.dto.ResultModel
     */
    @LogBefore(operType = "/mediaTest/update", keyName = "媒体测试添加")
    @RequestMapping(value = "/update", method = RequestMethod.POST, produces = "application/json")
    public ResultModel update(HttpServletRequest request, HttpServletResponse response,
                           MediaTestDto mediaTestDto) {
        try {
            // 参数校验
            if (BeanValidator.validateGroup(mediaTestDto, MediaTestDto.Add.class) != null) {
                return ResultModelFactory.FAIL400(BeanValidator.validateGroup(mediaTestDto,
                                                                              MediaTestDto.Add.class).getMessage());
            }
            // 获取后台用户名
            String userName = getUser(request, response).getUsername();
            mediaTestService.update(mediaTestDto, userName);
            return ResultModelFactory.SUCCESS(null);
        } catch (Exception e) {
            LOGGER.error("修改媒体测试广告位出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }
    /**
     * @description
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param request
     * @param response
     * @param
     * @return com.bxm.util.dto.ResultModel
     */
    @LogBefore(operType = "/mediaTest/updateStatus", keyName = "媒体测试添加")
    @RequestMapping(value = "/updateStatus", method = RequestMethod.POST, produces = "application/json")
    public ResultModel updateStatus(HttpServletRequest request, HttpServletResponse response,
                                    Long id,Integer type) {
        try { 
            mediaTestService.updateStatus(id,type);
            return ResultModelFactory.SUCCESS(null);
        } catch (Exception e) {
            LOGGER.error("媒体测试修改状态出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }
    /**
     * @description
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param request
     * @param response
     * @param
     * @return com.bxm.util.dto.ResultModel
     */
    @LogBefore(operType = "/mediaTest/delete", keyName = "媒体测试添加")
    @RequestMapping(value = "/delete", method = RequestMethod.POST, produces = "application/json")
    public ResultModel delete(HttpServletRequest request, HttpServletResponse response,
                                    Long id) {
        try { 
            mediaTestService.delete(id);
            return ResultModelFactory.SUCCESS(null);
        } catch (Exception e) {
            LOGGER.error("媒体测试删除广告位出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }

    /**
     * @description
     * @author sunzhongshu
     * @time 2018/5/18
     * @CopyRight 杭州微财科技有限公司
     * @param request
     * @param response
     * @return com.bxm.util.dto.ResultModel
     */
    @RequestMapping(value = "/findOcpcTicketByParam", method = RequestMethod.POST, produces = "application/json")
    public ResultModel<PageInfo<MediaTicketVo>> findOcpcTicketByParam(HttpServletRequest request, HttpServletResponse response,
                                                                  @RequestParam(value = "pageNum",required = false,defaultValue = "1") Integer pageNum,
                                                                  @RequestParam(value = "pageSize",required = false,defaultValue = "20") Integer pageSize,
                                                                  @RequestParam(value = "keywords",required = false  ) String keywords,
                                                                  @RequestParam(value = "ids",required = false  ) String ids) {
        ResultModel<PageInfo<MediaTicketVo>> rs = new ResultModel<PageInfo<MediaTicketVo>>();
        try {

            PageInfo<MediaTicketVo> result = mediaTestService.findOcpcTicketByParam(keywords,pageNum,pageSize,ids);
            if (result != null) {
                rs.setReturnValue(result);
            }
        }  catch (Exception e) {
            LOGGER.error("媒体测试默认加载列表出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
        return rs;
    }

    /**
     *查找满足条件的ocpc的券的id
     * @CopyRright  (c) 2018-微财科技有限公司
     * @author sunzhongshu
     * @created 2018/5/22 16:34
     * @modifier sunzhongshu
     */
    @RequestMapping(value = "/findOcpcTicketId", method = RequestMethod.POST, produces = "application/json")
    public ResultModel<List<Integer>> findOcpcTicketId(){
        ResultModel<List<Integer>> resultModel = new ResultModel<>();
        try{
            resultModel.setReturnValue( mediaTestService.findOcpcTicketId());
        }catch (Exception e){
            LOGGER.error("媒体测试获取广告位的所有券出错" + e.getMessage(), e);

        }
        return resultModel;
    }

}
