package com.bxm.adsmanager.web.controller.media;
import com.bxm.adsmanager.model.vo.media.MediaTicketVo;
import com.bxm.adsmanager.service.media.MediaTicketTagService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author 拉拉
 * @version v1.1.4_Ticket
 * @fileName com.bxm.adsmanager.web.controller.adticketpopup.AdPopup.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2018-03-01 11:48:00
 * @modifier 拉拉
 * @updated 2018-03-01 11:48:00
 */
@RestController
@RequestMapping("/mediaTicketTag")
public class MediaTicketTagController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTicketTagController.class);

    @Autowired
    private   MediaTicketTagService mediaTicketTagService;
       
    /**
     * @description
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param request
     * @param response 
     * @return com.bxm.util.dto.ResultModel
     */ 
    @RequestMapping(value = "/findTicketByParam", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<PageInfo<MediaTicketVo>> findTicketByParam(HttpServletRequest request, HttpServletResponse response,
                                                                  @RequestParam(value = "pageNum",required = false,defaultValue = "1") Integer pageNum,
                                                                  @RequestParam(value = "pageSize",required = false,defaultValue = "20") Integer pageSize,
                                                                  @RequestParam(value = "keywords",required = false  ) String keywords,
                                                                  @RequestParam(value = "ids",required = false  ) String ids,
                                                                  @RequestParam(value = "type",required = true  ,defaultValue = "1") String type,
                                                                  @RequestParam(value = "parentId",required = false  ) String parentId,
                                                                  @RequestParam(value = "childId",required = false  ) String childId,
                                                                  @RequestParam(value = "statusCode",required = false) String statusCode,
                                                                  @RequestParam(value = "positionId" ,required = false ) String positionId) throws Exception{
        ResultModel<PageInfo<MediaTicketVo>> rs = new ResultModel<PageInfo<MediaTicketVo>>();
        try {
     
            PageInfo<MediaTicketVo> result = mediaTicketTagService.findTicketByParam(keywords,pageNum,pageSize,ids, type,parentId,statusCode,positionId,childId);
            if (result != null) {
                rs.setReturnValue(result);
            }
        } catch (Exception e) {
            LOGGER.error("媒体查找广告券列表出错:" + e.getMessage() + ",queryString=" + request.getQueryString(), e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
        return rs;
    }
     
}
