package com.bxm.adsmanager.web.controller.media;

import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.vo.AdvanceAppFlowRecordTotalVo;
import com.bxm.adsmanager.service.media.PrepaidMediaService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.utils.UserRoleCodeUtil;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.adsmedia.facade.model.provider.advance.AdvanceAppFlowRecordRO;
import com.bxm.adsmedia.facade.model.provider.advance.QueryAdvanceAppParamsDTO;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
* @Title:PrepaidMediaController.java
* @Package:com.bxm.adsmanager.web.controller.media
* @Description: 预付媒体操作类
* @date:2018年9月5日 上午11:58:12
 */
@RestController
@RequestMapping("/media")
public class PrepaidMediaController extends BaseController {

    @Autowired
    private PrepaidMediaService prepaidMediaService;
    
    private static final Logger LOG = LoggerFactory.getLogger(PrepaidMediaController.class);
    
    /**
    * @Title: getAdvanceAppSumFlowRecord  
    * @Description: 查询预付媒体的资金流水列表
    * @param dto QueryAdvanceAppParamsDto
    * @return ResultModel<PageInfo<AdvanceAppFlowRecordTotalVo>> 
     */
    @RequestMapping(value = "/advanceAppFacade/getAdvanceAppSumFlowRecord", method = RequestMethod.POST)
    ResultModel<PageInfo<AdvanceAppFlowRecordTotalVo>> getAdvanceAppSumFlowRecord(HttpServletRequest request,
                                                                                  HttpServletResponse response,
                                                                                  @RequestBody QueryAdvanceAppParamsDTO dto){
        if(null == dto){
            dto = new QueryAdvanceAppParamsDTO();
        }
        //普通媒介的权限控制
        User user = getUser(request, response);
        String userName = null;
        String bd = null;
       /* //如果用户只为普通媒介角色CODE 则加上限制
        if (user != null && user.getRoleCodes() != null && user.getRoleCodes().size() == 1 &&
                user.getRoleCodes().contains(RoleEnum.MJ.getCode())) {
            userName = user.getUsername();
        }*/
        //登录角色是mj时
        if (StringUtils.isNotBlank(UserRoleCodeUtil.isMj(user))){
            userName = user.getUsername();
        }
        //登录角色是bd时
        if (StringUtils.isNotBlank(UserRoleCodeUtil.isBd(user))){
            bd = user.getUsername();
        }
        return ResultModelFactory.SUCCESS(prepaidMediaService.getAdvanceAppSumFlowRecord(dto,userName,bd));
    }
    
    /**
    * @Title: getAdvanceAppFlowRecords  
    * @Description: 查询预付媒体的资金流水详情
    * @return ResultModel<PageInfo<AdvanceAppFlowRecordVo>> 
     */
    @RequestMapping(value = "/advanceAppFacade/getAdvanceAppFlowRecords", method = RequestMethod.GET)
    ResultModel<PageInfo<AdvanceAppFlowRecordRO>> getAdvanceAppFlowRecords(
            @RequestParam(value = "appKey",required = true) String appKey,
            @RequestParam(value = "startTime", required = false) String startTime,
            @RequestParam(value = "endTime", required = false) String endTime,
            @RequestParam(value = "onlyShowRechargeFlag", required = false) Integer onlyShowRechargeFlag,
            @RequestParam(value = "pageNum", required = false) Integer pageNum,
            @RequestParam(value = "pageSize", required = false) Integer pageSize){
        return ResultModelFactory.SUCCESS(prepaidMediaService.getAdvanceAppFlowRecords(appKey, startTime, endTime, onlyShowRechargeFlag, pageNum, pageSize));
    }
    
}
