package com.bxm.adsmanager.web.controller.menu;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.bxm.adsmanager.model.dto.menu.AdMenuDto;
import com.bxm.adsmanager.model.vo.AdMenuVo;
import com.bxm.adsmanager.model.vo.MenuPermissionVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdTicketProfitSearchDto;
import com.bxm.adsmanager.service.menu.AdMenuRoleService;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RequestMapping("/adMenu")
@RestController
public class AdMenuController extends BaseController{
	
	private static final Logger LOGGER = LoggerFactory.getLogger(AdMenuController.class);
	
	@Autowired
	private AdMenuRoleService adMenuRoleService;

	/**  
	 * @Title: findMenuByCode  
	 * @Description:  通过Role查询菜单信息
	 * @author xavier  
	 * @date 2018年3月20日
	 */  
	@RequestMapping(value = "/findMenuByRole", method = RequestMethod.GET)
	public ResultModel<MenuPermissionVo> findAll(HttpServletRequest request,
			HttpServletResponse response,AdTicketProfitSearchDto search){
		response.setHeader("Access-Control-Allow-Origin", "*");
		ResultModel<MenuPermissionVo> rs = new ResultModel<>();
		try {
			MenuPermissionVo menuPermissionVo = new MenuPermissionVo();

			User user = getUser(request, response);
			List<AdMenuVo> menus = adMenuRoleService.findMenuByRole(user.getRoleCodes());

			menuPermissionVo.setUsername(user.getUsername());
			menuPermissionVo.setRole(user.getRoleCodes());
			menuPermissionVo.setPermission(menuVo2Dto(menus));

			rs.setReturnValue(menuPermissionVo);
		} catch (Exception e) {
			LOGGER.error("查询角色菜单列表错误"+e.getMessage(), e);
			rs.setSuccessed(false);
			rs.setErrorDesc("查询角色菜单列表错误");
		}
		return rs;
	}

	private List<AdMenuDto> menuVo2Dto(List<AdMenuVo> menus) {
		List<AdMenuDto>result = new ArrayList<AdMenuDto>();
		for(AdMenuVo vo : menus){
			result.add(new AdMenuDto(vo));
		}
		return result;
	}
}
