package com.bxm.adsmanager.web.controller.outsidte;

import com.bxm.adsmanager.model.dao.adkeeper.AdAssets;
import com.bxm.adsmanager.model.dto.outside.AdTicketOutsideDto;
import com.bxm.adsmanager.model.vo.outside.AdticketOutsideVo;
import com.bxm.adsmanager.service.outside.AdticketOutsideService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import java.math.BigInteger;
import java.util.List;

/**
 * 礼券三方外投控制器
 *
 * @ClassName TicketOutsideController
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/6/15 16:24
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/6/15 16:24
 **/
@RestController
@RequestMapping("/ticket/outside")
public class TicketOutsideController {
    @Autowired
    AdticketOutsideService adticketOutsideService;

    /**
     * 新增外投链接推送redis
     *
     * @param request
   * @param response
   * @param adTicketOutsideDto
     * @return com.bxm.util.dto.ResultModel
     * @throws
     * @author kk.xie
     * @date 2018/6/15 17:20
     */
    @LogBefore(operType = "/ticket/outside/add", keyName = "新增外投链接推送redis")
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResultModel add(HttpServletRequest request, HttpServletResponse response, AdTicketOutsideDto adTicketOutsideDto){
        // 校验参数
        ConstraintViolation constraintViolation = BeanValidator.validate(adTicketOutsideDto);
        if(constraintViolation != null){
            return ResultModelFactory.FAIL400(constraintViolation.getMessage());
        }

        adticketOutsideService.add(adTicketOutsideDto);
        return ResultModelFactory.SUCCESS();
    }

    /**
     * 根据素材ID 查询礼券ID及落地页信息
     *
     * @param assetId
     * @return java.util.List<com.bxm.adsmanager.model.vo.outside.AdticketOutsideVo>
     * @throws
     * @author kk.xie
     * @date 2018/6/15 17:20
     */
    @RequestMapping(value = "/getAssetTicketInfo", method = RequestMethod.GET)
    public ResultModel getAssetTicketInfo(BigInteger assetId){
        ResultModel resultModel = new ResultModel();
        List<AdticketOutsideVo> adticketOutsideVoList = adticketOutsideService.getAssetTicketInfo(assetId);
        resultModel.setReturnValue(adticketOutsideVoList);
        return resultModel;
    }

    @RequestMapping(value = "/findAllAssetsByTicketId", method = RequestMethod.GET)
    public ResultModel<List<AdticketOutsideVo>>findAllAssetsByTicketId(@RequestParam(required = true, name = "ticketId")Long ticketId) {
        ResultModel<List<AdticketOutsideVo>> rs = new ResultModel<>();
        List<AdticketOutsideVo> list = adticketOutsideService.findAllAssetsById(ticketId);
        rs.setReturnValue(list);
        return  rs;
    }

}
