package com.bxm.adsmanager.web.controller.overseas;

import com.bxm.adsmanager.model.dto.overseas.OverseasOfflineAdvertDto;
import com.bxm.adsmanager.model.vo.overseas.OverseasOfflineAdvertConditionVo;
import com.bxm.adsmanager.model.vo.overseas.OverseasOfflineAdvertVo;
import com.bxm.adsmanager.service.overseas.OverseasOfflineAdvertService;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


/**
 * 海外离线广告运营后台查询
 *
 * @author zhangdong
 * @date 2022/10/27
 */
@RestController
@RequestMapping("/overseas/offline/advert")
public class OverseasOfflineAdvertController {

    @Autowired
    private OverseasOfflineAdvertService advertService;

    /**
     * 获取所有的条件信息
     *
     * @return
     */
    @GetMapping("/condition")
    public ResultModel<OverseasOfflineAdvertConditionVo> getCondition() {
        ResultModel<OverseasOfflineAdvertConditionVo> model = new ResultModel<>();
        model.setReturnValue(advertService.getCondition());
        return model;
    }

    /**
     * 根据id查询广告
     *
     * @param id 主键id
     * @return
     */
    @GetMapping("/advertById")
    public ResultModel<OverseasOfflineAdvertVo> getAdvertById(@RequestParam("id") Long id) {
        ResultModel<OverseasOfflineAdvertVo> model = new ResultModel<>();
        model.setReturnValue(advertService.getAdvertById(id));
        return model;
    }

    /**
     * 根据条件查询广告列表
     *
     * @param dto
     * @return
     */
    @PostMapping("/advertList")
    public ResultModel<PageInfo<OverseasOfflineAdvertVo>> getAdvertList(@RequestBody OverseasOfflineAdvertDto dto) {
        ResultModel<PageInfo<OverseasOfflineAdvertVo>> model = new ResultModel<>();
        model.setReturnValue(advertService.getAdvertList(dto));
        return model;
    }


}
